\name{componentwise-ops}
\alias{psum}
\alias{pmean}
\title{Componentwise operations}
\description{
  Sum vectors componentwise, or take their mean. These are
  in the same spirit as \code{\link{pmin}} and \code{\link{pmax}}.
}
\usage{
psum(...)
pmean(...)
}
\arguments{
  \item{\dots}{the vectors to be summed or meaned}
}
\value{
  The componentwise sum, or the componentwise mean
}
\seealso{\code{\link{fold}}}
\examples{
psum(c(1,2,3), c(2,3,4), c(2,2,1))
pmean(c(1,2,3), c(2,3,4), c(2,2,1))

# An alternative method using fold
vecs <- list(c(1,2,3), c(2,3,4), c(2,2,1))
fold(vecs, FUN=function(x,y) x+y)
}
\keyword{arith}
