\name{panel.xyeplot}
\alias{panel.xyeplot}
\alias{prepanel.xyeplot}
\title{Default panel functions for xyeplot}
\description{This is the default panel and prepanel function for \code{xyeplot}.}
\usage{
panel.xyeplot(x,y,...,err,
    groups=NULL,subgroups,
    jitter.x,
    panel.groups=panel.xyeplot,accumulator=panel.superpose,
    type='b',
    col.line = if(is.null(groups)) plot.line$col else superpose.line$col,
    lty = if(is.null(groups)) plot.line$lty else superpose.line$lty,
    lwd = if(is.null(groups)) plot.line$lwd else superpose.line$lwd,
    col = if(is.null(groups)) plot.symbol$col else superpose.symbol$col,
    col.symbol = col,
    pch = if(is.null(groups)) plot.symbol$pch else superpose.symbol$pch,
    cex = if(is.null(groups)) plot.symbol$cex else superpose.symbol$cex,
    fill = if(is.null(groups)) plot.symbol$fill else superpose.symbol$fill)
prepanel.xyeplot(x,y,...,err,subscripts=seq(along=x))
}
\arguments{
  \item{x,y}{variables to be plotted}
  \item{\dots}{other arguments; passed on to the accumulator and the
    panel.groups function if there are groups specified, and then
    ultimately passed on to \code{\link[lattice]{panel.lines}} and
    \code{\link[lattice]{panel.points}}}
  \item{err, jitter.x}{as described in \code{\link{xyeplot}}}
  \item{subscripts, groups, subgroups, panel.groups, accumulator}{grouping commands, as for \code{\link{xyeplot}}}
  \item{type}{a character vector, consisting of one or more of 'l' for
    lines, 'p' for points, or 'b' for both lines and points}
  \item{col.line, lty, lwd, col, col.symbol, pch, cex, fill}{styling
    commands for the lines}
}
\details{
  If there is only one group/subgroup to plot, then \code{panel.xyeplot}
  plots the points and the error bars. It uses styles \code{col.line},
  \code{lty} and \code{lwd} to draw them.

  If there are several groups or subgroups, then \code{panel.xyeplot}
  splits the data up in the normal way first and calls
  \code{panel.groups} on each group/subgroup, using the
  \code{accumulator}.
}  
\seealso{\code{\link{xyeplot}},
  \code{\link[lattice]{panel.superpose}},
  \code{\link{panel.superpose2}}
}
\author{DJW}
