\name{panel.bwplot2}
\alias{panel.bwplot2}
\alias{prepanel.bwplot2}
\title{Default panel functions for bwplot2}
\description{This is the default panel and prepanel function for \code{bwplot2}.}
\usage{
panel.bwplot2(x,y,...,subscripts,err,
	jitter.x,
	groups=NULL, subgroups,
	panel.groups=panel.bwplot2, accumulator=panel.superpose,
        col.line = if(is.null(groups)) plot.line$col else superpose.line$col,
        lty = if(is.null(groups)) plot.line$lty else superpose.line$lty,
        lwd = if(is.null(groups)) plot.line$lwd else superpose.line$lwd)
prepanel.bwplot2(x,y,...,groups,subscripts,err)
}
\arguments{
  \item{x,y}{variables to be plotted}
  \item{\dots}{other arguments; passed on to the accumulator and the
    panel.groups function if there are groups specified, and then
    ultimately passed on to \code{\link[lattice]{panel.xyplot}}}
  \item{subscripts}{an integer vector, indicating which entries of the
    complete data set are to be printed in this panel}
  \item{err, jitter.x}{styling commands described in \code{\link{bwplot2}}}
  \item{groups, subgroups, panel.groups, accumulator}{grouping commands,
    as for \code{\link{bwplot2}}}
  \item{col.line, lty, lwd}{styling commands for the lines}
}
\details{
  If there is only one group/subgroup to plot, then \code{panel.bwplot2}
  groups the data into collections of distinct \code{x} values, then plots
  the mean or median \code{y} value (as specified by the \code{err}
  option) for each \code{x} using \code{\link[lattice]{panel.xyplot}}. It then
  computes error bars according to the \code{err} option and draws them.

  If there are several groups or subgroups, then \code{panel.bwplot2}
  splits the data up in the normal way first and calls
  \code{panel.groups} on each group/subgroup, using the
  \code{accumulator}.
}  
\seealso{\code{\link{bwplot2}}, \code{\link[lattice]{panel.xyplot}},
  \code{\link[lattice]{panel.superpose}},
  \code{\link{panel.superpose2}}
}
\author{DJW}
