\name{outof}
\alias{outof}
\alias{[<-.outof}
\alias{[.outof}
\alias{outof<-}
\alias{print.outof}
\title{A numeric class which keeps track of what the number is out of}
\description{
  A numeric class which keeps track of what each number is out of. This
  is useful for scoring when some of the items are missing.
}
\usage{
outof(x,\dots)
}
\arguments{
  \item{x}{either a numeric vector or an ``outof'' vector}
  \item{\dots}{other arguments; see Details}
  }

\details{
  \preformatted{outof(x, o)}
  is used to create a new ``outof'' vector. Here \code{x} is a numeric vector of values,
  and \code{o} is a numeric vector indicating what \code{x} is out of. If \code{o} is a single
  value, that value is used for each item in \code{x}. The return value is a numeric vector
  of class ``outof''.

  \preformatted{outof(y)}
  returns a vector which says what each element of \code{y} is out of.
}
\author{DJW}
\seealso{See \code{\link{flatten.outof}} for arithmetical operations on
  ``outof'' vectors.}
\examples{
x <- outof(1:3,3)
}
\keyword{arith}
