\name{outof-ops}
\alias{flatten}
\alias{flatten.outof}
\alias{as.numeric.outof}
\alias{as.character.outof}
\alias{\%+\%}
\alias{\%-\%}
\alias{\%+\%.outof}
\alias{\%-\%.outof}
\title{Operations on ``outof'' vectors}
\description{
  Add, subtract, and flatten numeric vectors, keeping track of what
  each element is out of.
}
\usage{
\method{flatten}{outof}(x,\dots)
\method{as.numeric}{outof}(x,\dots)
\method{as.character}{outof}(x,\dots)
x \%+\% y
x \%-\% y
}
\arguments{
  \item{x,y}{numeric vectors of class \code{\link{outof}}}
  \item{\dots}{other arguments, ignored}
}
\details{
  Perform arithmetic, keeping track of what the total is out of. For
  example, \code{1/3+2/5=3/8}. For these purposes, \code{NA} counts as
  \code{0/0}.
}
\value{
  \item{\code{flatten(x)}}{turn \code{x} into a vector of fractions in [0,1],
    e.g. \code{2/4} becomes \code{0.5}}
  \item{\code{x \%+\% y}}{adds \code{x} and \code{y}}
  \item{\code{x \%-\% y}}{subtracts \code{y} from \code{x}---a meaningless
    operation, unless \code{y} had previously been added to \code{x}}
  \item{\code{as.numeric(x)}}{returns the raw values, dropping the
    outof}
  \item{\code{as.character(x)}}{converts to a character vector}
}
\author{DJW}
\seealso{\code{\link{outof}}}
\keyword{arith}
\examples{
x <- outof(3,5) \%+\% outof(2,2)
flatten(x)
# tautology
x <- outof(as.numeric(x), outof(x))
}
