\name{locf}
\title{Last Observation Carried Forward}
\alias{locf}
\description{
  Calculate LOCF
}
\usage{
locf(x,data)
}
\arguments{
  \item{x}{a formula, of the form \code{obs~time|id},
    where \code{obs} are the observations, \code{time} are the
    timepoints at which the observations were made, and \code{id} are
    the individuals who were observed}
  \item{data}{an optional data frame, from which to take the terms in
    \code{x}; this data frame should have one row per \code{id:time}, so
  it may have multiple rows per \code{id}}
}
\value{
  A data frame with columns labelled as in the formula \code{x}, plus an
  extra column labelled \code{imputed} and another called \code{imputedfrom}. This data frame may be longer
  than the original data frame, since it has one row for every possible
  combination of \code{id:time}. The \code{imputed} column is either
  \code{TRUE} if the corresponding observation was imputed by LOCF, and
  \code{FALSE} if it is a genuine observation. The \code{imputedfrom}
  specifies which timepoint was carried forwards; if
  \code{time=imputedfrom} then the observation was not imputed.
}
\author{DJW}
\examples{
df <- data.frame(person=c('fred','fred','fred','jim','jim'),
                 visit=factor(c('v0','v1','v3','v2','v4'),levels=c('v0','v1','v2','v3','v4')),
                 count=1:5)
locf(count~visit|person, data=df)
}
\keyword{data}
