\name{leastN}
\title{Find an integer root for a decreasing function}
\alias{leastN}
\description{
  Find the smallest integer i>=0 such that fn(i)<=target, by repeated bisection
}
\usage{
leastN(fn,target=0,init=2,maxiter=12)
}
\arguments{
  \item{fn}{a decreasing function (may be non-strictly decreasing)}
  \item{target}{the target we want to hit, \code{fn(i)<=target}}
  \item{init}{initial guess for i}
  \item{maxiter}{number of iterations to obtain an initial bound}
}
\value{
  The smallest integer i such that \code{fn(i)<=target}.
}
\author{DJW}
\examples{
leastN(function(x) exp(-0.01*x), target=.5)
}
\keyword{optimize}
