\name{crossproduct}
\alias{crossproduct}
\title{Set-theoretic cross product}
\description{
  \code{crossproduct} takes a list of levels, and returns either a data frame
  containing all possible combinations of those levels, or a function
  applied to the columns of that data frame.
}
\usage{
crossproduct(...,FUN=NULL)
}
\arguments{
  \item{...}{a collection of vectors or factors, each specifying one of
    the sets in the crossproduct; these should all be named}
  \item{FUN}{an optional function. It should have as many arguments as
    there are items in \code{...}, in the same order.}
}
\value{
  If \code{FUN} is not specified, then \code{crossproduct} returns a
  data frame with one column for each entry in \code{...}, and one row
  for every element in the crossproduct. The first column varies the slowest.

  If \code{FUN} is specified, then the function is applied to these
  columns, and \code{crossproduct} returns the result.
}
\author{DJW}
\examples{
crossproduct(Age=10:15, Sex=c('male','female'))
crossproduct(Age=10:15, Sex=c('male','female'), FUN=function(Age,Sex) paste(Age,Sex,sep='-'))
}
\keyword{manip}
