\name{contr.popn}
\alias{contr.popn}
\title{Population contrasts}
\description{
  Constructs a contrast matrix for a factor, such that the intercept term
  corresponds to the population mean, and the contrast coefficients
  describe differences from the population mean.
}
\usage{
contr.popn(x,baselevel=levels(factor(x))[1])
}
\arguments{
  \item{x}{a factor}
  \item{baselevel}{the name of the factor level which will not have its own
    contrast term}
}
\details{
  Suppose we have a collection of observations, classified by male/female.
In a linear model using
\code{contr.sum} contrasts, the \code{(Intercept)} term gives the
mean response, half way between male response and female response.
But this does not correspond to the population mean, when the numbers in
each group are unequal, and this may be disconcerting. The contrasts
returned by \code{contr.popn} are such that the \code{(Intercept)} term
gives the population-weighted mean response.
}
\value{
the factor \code{x}, but with the \code{contrasts} attribute set such
that a linear model reports population contrasts.
}
\author{DJW}
\seealso{\code{\link{contr.sum}}}
\examples{
df <- data.frame(x=1:10,y=rep(c('a','b','c'),times=c(3,5,2)))
df$y <- contr.popn(df$y)
summary(lm(x~y,data=df))
}
\keyword{models}
