\name{cleanstrata}
\alias{cleanstrata}
\title{Extract the names of the strata from a survival fit}
\description{Extract the names of the strata from a survival fit. This
  is useful for plotting.}
\usage{
cleanstrata(fit)
}
\arguments{
  \item{fit}{a survival fit, obtained by
    \code{\link[survival]{survfit}}}
}
\value{
  a character vector, listing the strata used in the fit
}
\keyword{survival}
\author{DJW}
\examples{
data(rats)
df <- data.frame(time=rats$time,litter=rats$litter,died=rats$status==1,
                 treat=ifelse(rats$rx==0,'control','treat'))
fit <- survfit(Surv(time,died) ~ treat, data=df)
cols = c(treat='red',control='black')
plot(fit, col=cols[cleanstrata(fit)])
legend(legend=cleanstrata(fit),col=cols[cleanstrata(fit)],lty=1,x='bottomleft',)
}
