\name{bwplot2}
\title{Souped up box-and-whiskers plot}
\alias{bwplot2}
\description{
  A scatter plot of one variable against another. The vertical axis is
  drawn with error bars.
}
\usage{
bwplot2(x,data,...,err='bw',jitter.x=TRUE,
                    panel=panel.bwplot2,prepanel=prepanel.bwplot2,
                    subgroups,
                    accumulator=if(missing(subgroups)) panel.superpose else panel.superpose2)
}
\arguments{
  \item{x}{a formula to plot, of the form \code{y~x|cond}, as in \code{\link[lattice]{xyplot}}}
  \item{data}{a data frame containing any variables in the formula}
  \item{err}{the type of error bars to draw}
  \item{panel, prepanel}{panel plotting functions, like for \code{\link[lattice]{xyplot}}}
  \item{subgroups}{a subgrouping of the data, finer than the
    \code{groups} argument; points with the same value of \code{groups}
    are plotted in the same colour, and points with the same value of
    \code{subgroups} are connected by a line (if specified by \code{type})}
  \item{accumulator}{a function specifying how the data is to be broken
    down into groups and subgroups; the default is
    \code{panel.superpose} unless \code{subgroups} is specified in which
    case the default is \code{panel.superpose2}}
  \item{jitter.x}{whether to jitter x-coordinates, when there are
    several groups and the x-coordinate is a factor; \code{jitter.x} may be
    either a boolean saying whether to jitter, or a number saying how
    much to jitter}
  \item{...}{other arguments for \code{\link[lattice]{xyplot}}}
}
\details{
  Typical usage: \preformatted{
  bwplot2(x,data,...,err,jitter.x,subgroups,type='b')}

  Suppose the formula is \code{y~x|cond}. Like
  \code{\link[lattice]{bwplot}}, for each level of \code{cond} and each
  value of \code{x}, all the relevant \code{y} values are grouped, and a
  summary is computed; the summary consists of a point and error bars,
  and is specified by \code{err}:
  \describe{
    \item{\code{err='bw'}}{the median is plotted, with bars to show a
      standard box-and-whiskers plot}
    \item{\code{err='se'}}{the mean is plotted, with bars to show the
      standard error}
    \item{\code{err='seq'}}{the median is plotted, with bars to show the
      standard error of the median (specifically, 1.25 times the middle 68\% quantile, which is the standard error of the median
      for a normal distribution)}
    \item{\code{err=p}}{the mean is plotted, with a \code{p} confidence
      interval; the case \code{err='se'} corresponds to \code{p=0.68}}
    \item{\code{err='mean'}}{the mean is plotted, with no error bars}
    \item{\code{err='median'}}{the median is plotted, with no error
      bars}
    \item{\code{err='none'}}{the mean is plotted, with no error bars}
}
}
\value{
  an object of class "trellis", as returned by \code{\link[lattice]{xyplot}}.
}
\seealso{\code{\link{panel.bwplot2}}, \code{\link{prepanel.bwplot2}}}
\author{DJW}
\keyword{hplot}
