\name{Coefmat}
\alias{Coefmat}
\alias{print.Coefmat}
\alias{[.Coefmat}
\title{Pretty printing for coefficient matrices}
\description{
  An object with class \code{Coefmat} will print nicely, displaying a
  suitable number of digits and showing significance stars
}
\usage{
\method{print}{Coefmat}(x,
   pcol = which(tolower(colnames(x)) \%begins\% c('pr','sig','pval','p-val')),
   digits = max(3, getOption("digits") - 2),
   dig.tst = max(1, min(5, digits - 1)),
   signif.stars = getOption("show.signif.stars"),
   signif.legend = signif.stars,
   eps.Pvalue = .Machine$double.eps,
   na.print='NA',
   ...) 
}
\arguments{
  \item{x}{either a matrix or a data frame of class \code{Coefmat}}
\item{pcol}{a vector of integers, signifying those columns that should
be printed as p-values i.e. have significance stars shown next to them.
Default behaviour is that all columns with names which begin
\code{pr(}, \code{sig}, \code{pval} or \code{p-val} will be treated
as p-values.}
  \item{digits, dig.tst,
signif.stars, signif.legend,
eps.Pvalue,
na.print,
...}{other
    arguments, as used by \code{\link{summary.lm}}}
}
\author{DJW}
\keyword{arith}
