
as.data.frame.xxtabs.list <- function(x,row.names=NULL,optional=TRUE,drop=TRUE,col.var=NULL,order=order.slowfirst,...) {
  x1 <- as.table(x[[1]])
  if (is.null(row.names)) row.names <- 1:prod(dim(x1))
  covars <- as.data.frame(do.call('expand.grid',dimnames(x1)),row.names=row.names,optional=optional)
  o <- order(dim(x1))
  df <- cbind(covars,do.call('data.frame',c(list(row.names=1:prod(dim(x1)),check.names=FALSE),lapply(x, function(xx) c(xx)))))[o,]
  if(drop) df <- df[c(attr(x,'counts'))[o]>0,]
  if (is.null(col.var)) return(df)
  v.names <- attr(x,'names')
  bynames <- setdiff(names(df),v.names)
  if (!(col.var %in% bynames)) stop(paste('col.var must be one of',paste(bynames,collapse=','),sep=' '))
  reshape(df, dir='wide', idvar=setdiff(bynames,col.var), timevar=col.var, v.names=v.names)
}

as.data.frame.xxtabs <- function(x,row.names=NULL,optional=TRUE,drop=TRUE,col.var=NULL,order=order.slowfirst,...) {
  o <- order(dim(x))
  df <- NextMethod(x,responseName=attr(x,'responsevar'))[o,]
  if (drop) df <- df[c(attr(x,'counts'))[o]>0,]
  names(df)[length(names(df))] <- attr(x,'responsevar')
  if (is.null(col.var)) return(df)
  v.names <- attr(x,'responsevar')
  bynames <- setdiff(names(df),v.names)
  if (!(col.var %in% bynames)) stop(paste('col.var must be one of',paste(bynames,collapse=','),sep=' '))
  reshape(df, dir='wide', idvar=setdiff(bynames,col.var), timevar=col.var, v.names=v.names)
}

print.xxtabs <- function(x,...,na.print=NA) NextMethod(x,...,na.print=na.print)


print.xxtabs.list <- function(x,...) {
  attributes(x) <- list(names=names(x))
  print(x,...)
}

ALL <- function(a) a
xxtabs <- function (formula = ~., data = parent.frame(), subset,
                    na.action=na.pass, drop.unused.levels=TRUE,
                    FUN=list(n=sum), nocount.val=if(length(formula)==2) 0 else NA) {
    if (missing(formula)) stop("must supply formula")
    formula <- as.formula(formula)
    if (!inherits(formula, "formula")) stop("'formula' missing or incorrect")
    parseterms <- terms(formula,data=data,specials='ALL')
    if (any(attr(parseterms,"order")>1)) stop("interactions are not allowed")
    m <- match.call(expand.dots=FALSE)
    if (is.matrix(eval(m$data, parent.frame()))) m$data <- as.data.frame(data)
    m$... <- m$drop.unused.levels <- m$FUN <- m$nocount.val <- NULL
    m$na.action <- substitute(na.action)
    m[[1]] <- as.name("model.frame")
    # get a copy with no subset argument, to find out how many rows there are
    m0 <- m
    m0$subset <- NULL
    m0$na.action <- na.pass
    if (length(formula)==3) m0$formula <- formula[c(1,3)]
    mf0 <- eval(m0, parent.frame())
    # get a copy with the actual subset argument, and a dummy LHS
    if (length(formula)==3) m$formula[[2]] <- 1:nrow(mf0)
    mf <- eval(m, parent.frame())
    if (length(formula)==2) {
      by <- mf
      y <- rep(1,length.out=nrow(mf))
    }
    else {
      i <- attr(attr(mf,'terms'),'response')
      by <- mf[-i]
      i <- mf[[i]]
      # WANT: evaluate LHS of formula, extract rows i from it
      y <- eval(formula[[2]],data)
      if (NCOL(y)>1) y <- y[i,] else y <- rep(y,length.out=nrow(mf0))[i]
    }
    by <- lapply(by, function(u) {
        if (!is.factor(u)) u <- factor(u)
        u[, drop = drop.unused.levels] })
    termsall <- attr(parseterms,'specials')$ALL
    if (is.null(termsall)) termsall <- numeric(0)
    termsall <- termsall-(length(formula)-2) # ignore the LHS of the formula 
    for (ta in termsall) {
      varname <- attr(parseterms,'variables')[[ta+length(formula)-1]]
      names(by)[ta] <- deparse(varname[[2]])
    }
    # This is where we apply the functions
    if (!is.list(FUN)) {
        funname <- deparse(substitute(FUN))
        FUN <- list(FUN)
        names(FUN) <- funname
    }
    defaultnames <- paste('FUN', seq(along=FUN), sep='')
    if (is.null(names(FUN))) names(FUN)<-defaultnames
    ind <- which(nchar(names(FUN))==0)
    names(FUN)[ind] <- defaultnames[ind]
    counts <- tapplydjw(rep.int(1,NROW(y)),by,sum, ALL=termsall)
    counts[is.na(counts)] <- 0
    res <- lapply(seq(along=FUN), function(i) {
      f <- FUN[[i]]
      x <- tapplydjw(y,by,f,ALL=termsall)
      zeroval <- if(is.null(nocount.val))
        (if (NCOL(y)>1) f(y[c(),,drop=FALSE]) else f(y[c()]))
      else
        nocount.val
      x[counts==0] <- zeroval
      class(x) <- c('xxtabs','xtabs','table')
      cl <- match.call()
      cl$FUN <- NULL
      attr(x, "call") <- cl
      attr(x,'responsevar') <- names(FUN)[[i]]
      x
    })
    # Present it nicely
    if (length(FUN)==1)
      structure(res[[1]],call=match.call(),responsevar=names(FUN)[[1]],counts=counts)
    else
      structure(res,call=match.call(),class='xxtabs.list',names=names(FUN),counts=counts)
}

order.fastfirst <- function(dims) 1:prod(dims)
order.slowfirst <- function(dims) {
  cpr <- rev(cumprod(c(1,rev(dims)))[1:length(dims)])
  cpf <- cumprod(c(1,dims))[1:length(dims)]
  i <- rep(1,prod(dims))
  for (j in seq(along=dims)) i <- i + cpf[j]*((0:(prod(dims)-1) %/% cpr[j]) %% dims[j])
  i }



tapplydjw <- function(X, INDEX, FUN=NULL, ..., ALL=numeric(0)) {
  if (!is.list(INDEX)) INDEX <- list(INDEX)
  nx <- NROW(X)
  index <- lapply(seq(along=INDEX), function(i) {
    ind <- INDEX[[i]]
    if (length(ind)!=nx) stop(paste("Argument",names(INDEX)[i],"has the wrong length"))
    ind <- as.factor(ind)
    code <- as.integer(ind)-1
    lev <- levels(ind)
    n <- nlevels(ind)
    d <- n
    if (any(is.na(ind))) { code[is.na(ind)] <- n; lev <- c(lev,NA); n<-n+1; d<-d+1 }
    if (i %in% ALL) { lev <- c(lev,'ALL'); n<-n+1 }
    list(code=code, levels=lev, n=n, dim=d, all=n>d)
  })
  names(index) <- names(INDEX)
  dd <- sapply(index, function(ind) ind$d)
  nn <- sapply(index, function(ind) ind$n)
  dimprod <- cumprod(c(1,nn))
  all <- cumsum(nn-dd)-1
  numall <- sum(nn-dd)
  #
  group <- rep(1,nx*2^numall)
  for (i in seq(along=index)) {
    ind <- index[[i]]
    code <- ind$code * dimprod[i]
    group <- group + if(ind$all)
      rep(c(rep(code,2^all[i]),rep(dimprod[i]*(ind$n-1),nx*2^all[i])), 2^(numall-all[i]-1))
    else
      rep(code,2^numall)
  }
  #
  if (is.null(FUN)) return(group)
  X <- if (NCOL(X)==1) X[rep(1:nx,2^numall)] else X[rep(1:nx,2^numall),]
  ans <- lapply(split(X, group), FUN, ...)
  if (any(unlist(lapply(ans, length))>1)) stop(paste("Function must return a scalar, not [",
                                                     paste(ans[[which(unlist(lapply(ans,length))>1)[1]]],collapse=', '),']'))
  indn <- as.integer(names(ans))
  ans <- unlist(ans, recursive=FALSE)
  names(ans) <- NULL
  ansmat <- array(NA,dim=nn,dimnames=lapply(index, function(ind) ind$levels))
  ansmat[indn] <- ans
  ansmat
}

  
