xcumsum <- function(formula=~., orderby=1, data=parent.frame(), subset, na=0) {
  if (missing(formula)) stop('Must supply formula')
  formula <- as.formula(formula)
  if (!inherits(formula,'formula')) stop("'formula' missing or incorrect")
  parseterms <- terms(formula,data=data)
  if (any(attr(parseterms,'order')>1)) stop('Interactions are not allowed')
  #
  # Evaluate LHS, RHS, subset, order, all within the context of RHS
  m <- match.call(expand.dots=FALSE)
  #if (!is.matrix(eval(m$data,parent.frame()))) m$data <- as.data.frame(data)
  m$... <- m$na <- m$orderby <- NULL
  m$na.action <- na.pass
  m[[1]] <- as.name('model.frame')
  # Get the whole LHS and RHS
  m0 <- m
  m0$subset <- NULL
  mf0 <- eval(m0,parent.frame())
  i <- attr(attr(mf0,'terms'),'response')
  x <- mf0[-i]
  y <- mf0[[i]]
  # Get the order
  if (missing(orderby))
    o <- 1:nrow(mf0)
  else {
    m0$formula[[2]] <- substitute(orderby)
    mf0 <- eval(m0,parent.frame())
    i <- attr(attr(mf0,'terms'),'response')
    o <- mf0[[i]] }
  # Get the subset
  m$formula[[2]] <- 1:nrow(mf0)
  mf <- eval(m,parent.frame())
  i <- attr(attr(mf,'terms'),'response')
  s <- mf[[i]]
  #
  # Reorder, and cumsum
  if (NCOL(x)==0) x <- data.frame(1:nrow(mf0))
  oo <- do.call(order,c(x,list(order(o))))
  y[-s] <- 0
  y[is.na(y)] <- na
  ret <- cbind(x,resp=y,ord=oo)
  y <- y[oo]
  x <- x[oo,]
  reset <- !duplicated(x)
  y <- cumsum(y) - filldown(ifelse(reset,c(0,cumsum(y))[1:length(y)],NA))
  y[order(oo)][s]
}

