RweaveLatex.djw <- function() {
  res <- RweaveLatex()
  res$runcode <- function (object, chunk, options) 
{
    if (!(options$engine %in% c("R", "S"))) {
        return(object)
    }
    if (!object$quiet) {
        cat(formatC(options$chunknr, width = 2), ":")
        if (options$echo) 
            cat(" echo")
        if (options$eval) {
            if (options$print) 
                cat(" print")
            if (options$term) 
                cat(" term")
            cat("", options$results)
            if (options$fig) {
                if (options$eps) 
                  cat(" eps")
                if (options$pdf) 
                  cat(" pdf")
            }
        }
        if (!is.null(options$label)) 
            cat(" (label=", options$label, ")", sep = "")
        cat("\n")
    }
    chunkprefix <- RweaveChunkPrefix(options)
    if (options$split) {
        chunkout <- object$chunkout[[chunkprefix]]
        if (is.null(chunkout)) {
            chunkout <- file(paste(chunkprefix, "tex", sep = "."), 
                "w")
            if (!is.null(options$label)) 
                object$chunkout[[chunkprefix]] <- chunkout
        }
    }
    else chunkout <- object$output
    SweaveHooks(options, run = TRUE)
    chunkexps <- try(parse(text = chunk), silent = TRUE)
    RweaveTryStop(chunkexps, options)
    openSinput <- FALSE
    openSchunk <- FALSE
    if (length(chunkexps) == 0) 
        return(object)
    for (nce in 1:length(chunkexps)) {
        ce <- chunkexps[[nce]]
        dce <- deparse(ce, width.cutoff = 0.75 * getOption("width"))
        if (object$debug) 
            cat("\nRnw> ", paste(dce, collapse = "\n+  "), "\n")
        if (options$echo) {
            if (!openSinput) {
                if (!openSchunk) {
                  cat("\\begin{Schunk}\n", file = chunkout, append = TRUE)
                  openSchunk <- TRUE
                }
                cat("\\begin{Sinput}", file = chunkout, append = TRUE)
                openSinput <- TRUE
            }
            cat("\n", getOption("prompt"), paste(dce, collapse = paste("\n", 
                getOption("continue"), sep = "")), file = chunkout, 
                append = TRUE, sep = "")
        }
        tmpcon <- file()
        sink(file = tmpcon)
        err <- NULL
        if (options$eval) 
            err <- RweaveEvalWithOpt(ce, options)
        cat("\n")
        sink()
        output <- readLines(tmpcon)
        close(tmpcon)
        if (length(output) == 1 & output[1] == "") 
            output <- NULL
        RweaveTryStop(err, options)
        if (object$debug) 
            cat(paste(output, collapse = "\n"))
        if (length(output) > 0 & (options$results != "hide")) {
            if (openSinput) {
                cat("\n\\end{Sinput}\n", file = chunkout, append = TRUE)
                openSinput <- FALSE
            }
            if (options$results == "verbatim") {
                if (!openSchunk) {
                  cat("\\begin{Schunk}\n", file = chunkout, append = TRUE)
                  openSchunk <- TRUE
                }
                soutputcommand <- '\\begin{Soutput}'
                if (!is.null(options$label)) soutputcommand <- paste(soutputcommand,'[label=',options$label,']',sep='')
                cat(soutputcommand,'\n',sep='', file = chunkout, append = TRUE)
            }
            output <- paste(output, collapse = "\n")
            if (options$strip.white %in% c("all", "true")) {
                output <- sub("^[[:space:]]*\n", "", output)
                output <- sub("\n[[:space:]]*$", "", output)
                if (options$strip.white == "all") 
                  output <- sub("\n[[:space:]]*\n", "\n", output)
            }
            cat(output, file = chunkout, append = TRUE)
            remove(output)
            if (options$results == "verbatim") {
                cat("\n\\end{Soutput}\n", file = chunkout, append = TRUE)
            }
        }
    }
    if (openSinput) {
        cat("\n\\end{Sinput}\n", file = chunkout, append = TRUE)
    }
    if (openSchunk) {
        cat("\\end{Schunk}\n", file = chunkout, append = TRUE)
    }
    if (is.null(options$label) & options$split) 
        close(chunkout)
    if (options$split & options$include) 
        cat("\\input{", chunkprefix, "}\n", sep = "", file = object$output, 
            append = TRUE)
    if (options$fig && options$eval) {
        if (options$eps) {
            grDevices::postscript(file = paste(chunkprefix, "eps", 
                sep = "."), width = options$width, height = options$height, 
                paper = "special", horizontal = FALSE)
            err <- try({
                SweaveHooks(options, run = TRUE)
                eval(chunkexps, envir = .GlobalEnv)
            })
            grDevices::dev.off()
            if (inherits(err, "try-error")) 
                stop(err)
        }
        if (options$pdf) {
            grDevices::pdf(file = paste(chunkprefix, "pdf", sep = "."), 
                width = options$width, height = options$height, 
                version = options$pdf.version, encoding = options$pdf.encoding)
            err <- try({
                SweaveHooks(options, run = TRUE)
                eval(chunkexps, envir = .GlobalEnv)
            })
            grDevices::dev.off()
            if (inherits(err, "try-error")) 
                stop(err)
        }
        if (options$include) 
            cat("\\includegraphics{", chunkprefix, "}\n", sep = "", 
                file = object$output, append = TRUE)
    }
    return(object)
}
res
}

