predictFactors <- function(fit,new,...) UseMethod('predictFactors')

predictFactors.lm <- function(fit,new,contrasts,...)
  predictFactorsWork(fit,new,contrasts,...,
                     xlevels=fit$xlevels,
                     xcontrasts=fit$contrasts,
                     extracttermFUN=function(fit,wantterm)
                     coef(summary(fit))[wantterm,c('Estimate','Std. Error','Pr(>|t|)')])

predictFactors.glm <- function(fit,new,contrasts,...)
  predictFactorsWork(fit,new,contrasts,...,
                     xlevels=fit$xlevels,
                     xcontrasts=fit$contrasts,
                     extracttermFUN=function(fit,wantterm)
                     coef(summary(fit))[wantterm,c('Estimate','Std. Error','Pr(>|z|)')])


predictFactors.lme <- function(fit,new,contrasts,...)
  predictFactorsWork(fit,new,contrasts,...,
                     xlevels=lapply(fit$contrasts,rownames),
                     xcontrasts=fit$contrasts,
                     extracttermFUN=function(fit,wantterm)
                     summary(fit)$tTable[wantterm,c('Value','Std.Error','p-value')])

                     
predictFactorsWork <- function(fit, new, contrasts, ...,xlevels,xcontrasts,extracttermFUN) {
  getintercept <- TRUE
  if (!missing(contrasts)) {
    getintercept <- FALSE
    if (!is.list(contrasts)) stop('Contrasts should be a list')
    if (length(contrasts)!=1) stop('Contrasts should be a list of length 1')
    contrastname <- names(contrasts)[1]
    contrastbase <- as.character(contrasts[[1]])
    if (!(contrastname %in% names(new))) stop('Contrast ',contrastname,' is missing from new')
    if (contrastbase %in% new[[contrastname]]) stop('Contrast level ',contrastbase,' should not appear in new')
  }
  #
  vars <- names(xlevels)
  if (!all(vars %in% names(new))) stop('Specify each term ',paste(vars,collapse=', '))
  getcontrasts <- function(nn,base) {
    if (is.na(base)) return(xcontrasts[[nn]])
    base <- as.character(base)
    if (base=='MEAN') return('contr.sum')
    if (!(base %in% xlevels[[nn]])) stop('Unrecognized factor level ',base,' for ',nn)
    basepos <- which(xlevels[[nn]]==base)
    contr.treatment(xlevels[[nn]],basepos)
  }
  basecontrast <- list()
  newcontrnames <- names(new)[names(new) %in% vars]
  if (!getintercept) {
    basecontrast <- list(getcontrasts(contrastname,contrastbase))
    names(basecontrast) <- contrastname
    newcontrnames <- newcontrnames[newcontrnames!=contrastname]
    }
  res <- lapply(1:nrow(new), function(i) {
    newcontr <- lapply(newcontrnames, function(nn) getcontrasts(nn,new[i,nn]))
    names(newcontr) <- newcontrnames
    newcontr <- c(basecontrast,newcontr)
    newfit <- update(fit, contrasts=newcontr)
    wantterm <- '(Intercept)'
    if (!getintercept) wantterm <- paste(contrastname,new[i,contrastname],sep='')
    extracttermFUN(newfit,wantterm)
  })
  res <- do.call('rbind',res)
  colnames(res) <- c('estimate','std.error','Pr(>.)')
  class(res) <- c('Coefmat',class(res))
  res
}



