'outof<-' <- function(x,value) {
  attr(x,'outof') <- repsafe(value,length(x))
  class(x) <- 'outof'
  x
  }

outof <- function(x,...) {
  args = list(...)
  if (length(args)==0) {
    if ('outof' %in% class(x)) return(attr(x,'outof'))
    warning('Object of class ',class(x),' is not out of anything')
    return(NULL)
    }
  if (length(args)>1)
    warning('Ignoring extra arguments to outof')
  attr(x,'outof') <- repsafe(args[[1]],length(x))
  class(x) <- 'outof'
  return(x)
  }

as.numeric.outof <- function(x,...) { attributes(x) <- NULL; x }

setMethodS3('flatten','outof',
            function(x,...) {
              z <- x/attr(x,'outof')
              attributes(z) <- NULL
              z
            })

print.outof <- function(x,...,quote=FALSE) {
  z <- x
  class(z) <- NULL
  z <- paste(z,attr(x,'outof'),sep='/')
  z[is.na(x)] <- NA
  print(z,...,quote=quote)
  }

as.character.outof <- function(x,...) {
  z <- x
  class(z) <- NULL
  z <- paste(z,attr(x,'outof'),sep='/')
  z[is.na(x)] <- NA
  z
}

'[.outof' <- function(x,sub,...) {
  x <- unclass(x)
  y <- x[sub,...]
  attr(y,'outof') <- attr(x,'outof')[sub,...]
  class(y) <- 'outof'
  y }

'[<-.outof' <- function(x,subs,value) {
  if (!('outof' %in% class(value)) & !all(is.na(value)))
    warning('Assigned value is not outof anything')
  x <- unclass(x)
  x[subs] <- value
  if ('outof' %in% class(value))
    attr(x,'outof')[subs] <- attr(value,'outof')
  class(x) <- 'outof'
  x
}

if(!exists('%+%')) '%+%' <- function(x,y) UseMethod('%+%')
setMethodS3('%+%','outof',
function(x,y) {
  xx <- unclass(x)
  xx[is.na(xx)] <- 0
  yy <- unclass(y)
  yy[is.na(yy)] <- 0
  z <- xx+yy
  z[is.na(x) & is.na(y)] <- NA
  xout <- attr(x,'outof')
  yout <- attr(y,'outof')
  xout[is.na(x)] <- 0
  yout[is.na(y)] <- 0
  attr(z,'outof') <- xout+yout
  class(z) <- 'outof'
  z
  },appendVarArgs=FALSE)



if(!exists('%-%')) '%-%' <- function(x,y) UseMethod('%-%')
setMethodS3('%-%','outof',
function(x,y,...) {
  xx <- unclass(x)
  xx[is.na(xx)] <- 0
  yy <- unclass(y)
  yy[is.na(yy)] <- 0
  z <- xx-yy
  z[is.na(x) & is.na(y)] <- NA
  xout <- attr(x,'outof')
  yout <- attr(y,'outof')
  xout[is.na(x)] <- 0
  yout[is.na(y)] <- 0
  attr(z,'outof') <- xout-yout
  class(z) <- 'outof'
  z
  })



