indicator <- function(b) ifelse(b,1,0)
howmany <- function(b) length(which(b))
whatfraction <- function(b) mean(indicator(b[!is.na(b)]))
implies <- function(a,b) !a | (a & b)

psum <- function(...) {
  vs <- list(...)
  if (length(vs)==1) return(vs[[1]])
  pm <- vs[[1]]
  for (j in 2:length(vs))
    pm <- pm + vs[[j]]
  pm
  }

pmean <- function(...) psum(...)/length(list(...))

fold <- function(x,FUN,...) {
  if (!is.list(x)) stop('x must be a list')
  x1 <- x[[1]]
  if (length(x)==1) return(x1)
  for (i in 2:length(x)) x1 <- FUN(x1,x[[i]],...)
  x1 }

equal.num <- function(x,y) {
  n <- max(length(x),length(y));
  x <- repsafe(x,n); y <- repsafe(y,n)
  equal.numall(x,y) }
leq.num <- function(x,y) {
  n <- max(length(x),length(y));
  x <- repsafe(x,n); y <- repsafe(y,n);
  (equal.numall(x,y) | x<=y) }
geq.num <- function(x,y) {
  n <- max(length(x),length(y));
  x <- repsafe(x,n); y <- repsafe(y,n);
  (equal.numall(x,y) | x>=y) }
equal.numall  <- function(x,y)
  sapply(1:length(x),
         function(i) identical(all.equal(x[[i]],y[[i]]),TRUE))
comp.num <- function(x,y)
  ifelse(equal.num(x,y),0,ifelse(x<y,-1,1)) 

maxsafe <- function(...) {
  l <- list(...)
  if (length(l)==0) return(-Inf)
  m <- -Inf
  for (i in 1:length(l)) if (l[[i]]>m) m <- l[[i]]
  m
}
minsafe <- function(...) minsafelist(list(...))
minsafelist <- function(l) {
  if (length(l)==0) return(Inf)
  m <- Inf
  for (i in 1:length(l)) {
    li <- l[[i]];
    lm <- Inf;
    if (length(li)==1) lm <- li
    if (length(li)>1) lm <- minsafelist(as.list(li))
    if (lm<m) m <- lm
    }
  m
  }

se <- function(x,na.rm=TRUE) {
  if (na.rm) x <- x[!is.na(x)]
  sd(x)/sqrt(length(x))
}
