
setMethodS3('short','summary.lme',
            function(x,...) structure(x,class=c('short.summary.lme',setdiff(class(x),'short.summary.lme'))))

print.short.summary.lme <- function (x, verbose = FALSE, ...) 
{
    dd <- x$dims
    verbose <- verbose || attr(x, "verbose")
    if (inherits(x, "nlme")) {
        cat("Nonlinear mixed-effects model fit by ")
        cat(ifelse(x$method == "REML", "REML\n", "maximum likelihood\n"))
        cat("  Model:", deparse(x$call$model), "\n")
    }
    else {
        cat("Linear mixed-effects model fit by ")
        cat(ifelse(x$method == "REML", "REML\n", "maximum likelihood\n"))
    }
    method <- x$method
    cat(" Data:", deparse(x$call$data), "\n")
    if (!is.null(x$call$subset)) {
        cat("  Subset:", deparse(asOneSidedFormula(x$call$subset)[[2]]), 
            "\n")
    }
    print(data.frame(AIC = x$AIC, BIC = x$BIC, logLik = c(x$logLik), 
        row.names = " "))
    if (verbose) {
        cat("Convergence at iteration:", x$numIter, "\n")
    }
    cat("\n")
    print(summary(x$modelStruct), sigma = x$sigma, reEstimates = x$coef$random, 
        verbose = verbose)
    cat("Fixed effects: ")
    fixF <- x$call$fixed
    toprint <- if (inherits(fixF, "formula") || is.call(fixF))
      deparse(fixF)
    else
      deparse(lapply(fixF, function(el) as.name(deparse(el))))
    cat(paste(toprint,sep='\n',collapse='\n'), '\n\n',sep='')
    xtTab <- as.data.frame(x$tTable)
    wchPval <- match("p-value", names(xtTab))
    for (i in names(xtTab)[-wchPval]) {
        xtTab[, i] <- format(zapsmall(xtTab[, i]))
    }
    xtTab[, wchPval] <- format(round(xtTab[, wchPval], 4))
    if (any(wchLv <- (as.double(levels(xtTab[, wchPval])) == 
        0))) {
        levels(xtTab[, wchPval])[wchLv] <- "<.0001"
    }
    row.names(xtTab) <- dimnames(x$tTable)[[1]]
    print.Coefmat(xtTab)
    cat("\nStandardized Within-Group Residuals:\n")
    print(x$residuals)
    cat("\nNumber of Observations:", x$dims[["N"]])
    cat("\nNumber of Groups: ")
    Ngrps <- dd$ngrps[1:dd$Q]
    if ((lNgrps <- length(Ngrps)) == 1) {
        cat(Ngrps, "\n")
    }
    else {
        sNgrps <- 1:lNgrps
        aux <- rep(names(Ngrps), sNgrps)
        aux <- split(aux, array(rep(sNgrps, lNgrps), c(lNgrps, 
            lNgrps))[!lower.tri(diag(lNgrps))])
        names(Ngrps) <- unlist(lapply(aux, paste, collapse = " %in% "))
        cat("\n")
        print(rev(Ngrps))
    }
}
