crossproduct <- function(..., FUN=NULL) {
  inds <- list(...)
  # Validate the input
  if (length(inds)==0) stop('Must specify at least one index')
  inds <- lapply(inds, function(a) if (is.list(a)) a else list(a))
  inds <- do.call('c',inds)
  inds <- lapply(inds, function(x) if (is.numeric(x)) x else as.character(x))
  nn <- names(inds)
  if (is.null(nn)) nn <- rep(NA,length(inds))
  nn <- ifelse(is.na(nn) | nchar(nn)==0 | duplicated(nn),paste('X',seq(along=nn),sep=''),nn)
  names(inds) <- nn
  dups <- sapply(inds, function(x) any(duplicated(x)))
  if (any(dups)) warning('Duplicate levels (in ',paste(names(inds)[dups],collapse=', '),')')
  # Do the work
  dims <- sapply(inds,length)
  dimtot <- prod(dims)
  reps <- rev(cumprod(c(1,rev(dims))))[-1]
  valcols <- lapply(1:length(dims), function(j) {
    nl <- ((1:dimtot-1) %/% reps[j]) %% dims[j]
    res <- inds[[j]][nl+1]
    if (is.character(res)) res <- factor(res, levels=inds[[j]])
    res
    })
  names(valcols) <- names(inds)
  res <- do.call('data.frame',valcols)
  if (is.null(FUN)) return(res)
  do.call(FUN,res)
  }


