


summary.coxph.penal <- 
function (object, conf.int = 0.95, scale = 1, terms = FALSE, maxlabel = 25,  ...) 
{
  # Check if the fitted model is defective in some way
  if (!is.null(object$fail)) {
    cat(" Coxreg failed.", object$fail, "\n")
    return()
  }
  coef <- object$coef
  if (length(coef) == 0 && length(object$frail) == 0) 
    stop("Penalized summary function can't be used for a null model")
  if (length(coef) > 0) {
    nacoef <- !(is.na(coef))
    coef2 <- coef[nacoef]
    if (is.null(coef) | is.null(object$var)) 
      stop("Input is not valid")
  }
  # Store the old object
  rval <- list(object=object)
  class(rval) <- 'summary.coxph.penal'
  # Also, do all the calculations from summary.coxph.penal, just don't print them
    omit <- object$na.action
    coef <- object$coef
    if (length(coef) > 0) {
        nacoef <- !(is.na(coef))
        coef2 <- coef[nacoef]
        se <- sqrt(diag(object$var))
    }
    pterms <- object$pterms
    nterms <- length(pterms)
    npenal <- sum(pterms > 0)
    print.map <- rep(0, nterms)
    if (!is.null(object$printfun)) {
        temp <- unlist(lapply(object$printfun, is.null))
        print.map[pterms > 0] <- (1:npenal) * (!temp)
    }
    print1 <- NULL
    pname1 <- NULL
    if (is.null(object$assign2)) 
        alist <- object$assign[-1]
    else alist <- object$assign2
    print2 <- NULL
    for (i in 1:nterms) {
        kk <- alist[[i]]
        if (print.map[i] > 0) {
            j <- print.map[i]
            if (pterms[i] == 2) 
                temp <- (object$printfun[[j]])(object$frail, 
                  object$fvar, , object$df[i], object$history[[j]])
            else temp <- (object$printfun[[j]])(coef[kk], object$var[kk, 
                kk], object$var2[kk, kk], object$df[i], object$history[[j]])
            print1 <- rbind(print1, temp$coef)
            if (is.matrix(temp$coef)) {
                xx <- dimnames(temp$coef)[[1]]
                if (is.null(xx)) 
                  xx <- rep(names(pterms)[i], nrow(temp$coef))
                else xx <- paste(names(pterms)[i], xx, sep = ", ")
                pname1 <- c(pname1, xx)
            }
            else pname1 <- c(pname1, names(pterms)[i])
            print2 <- c(print2, temp$history)
        }
        else if (terms && length(kk) > 1) {
            pname1 <- c(pname1, names(pterms)[i])
            temp <- survival:::coxph.wtest(object$var[kk, kk], coef[kk])$test
            print1 <- rbind(print1, c(NA, NA, NA, temp, object$df[i], 
                1 - pchisq(temp, 1)))
        }
        else {
            pname1 <- c(pname1, names(coef)[kk])
            tempe <- (diag(object$var))[kk]
            temp <- coef[kk]^2/tempe
            print1 <- rbind(print1, cbind(coef[kk], sqrt(tempe), 
                sqrt((diag(object$var2))[kk]), temp, 1, 1 - pchisq(temp, 
                  1)))
        }
    }
  temp <- print1
    dimnames(temp) <- list(substring(pname1, 1, maxlabel), c("coef", 
        "se(coef)", "se2", "Chisq", "DF", "p"))
  rval$table <- temp
    if (conf.int & length(coef) > 0) {
        z <- qnorm((1 + conf.int)/2, 0, 1)
        coef <- coef * scale
        se <- se * scale
        tmp <- cbind(exp(coef), exp(-coef), exp(coef - z * se), 
            exp(coef + z * se))
        dimnames(tmp) <- list(substring(names(coef), 1, maxlabel), 
            c("exp(coef)", "exp(-coef)", paste("lower .", round(100 * 
                conf.int, 2), sep = ""), paste("upper .", round(100 * 
                conf.int, 2), sep = "")))
        rval$confint <- tmp
    }
    logtest <- -2 * (object$loglik[1] - object$loglik[2])
    sctest <- object$score
    if (is.null(object$df)) 
        df <- sum(!is.na(coef))
    else df <- round(sum(object$df), 2)
  rval$df <- format(round(object$df,1))
  rval$rsquare <- format(round(1 - exp(-logtest/object$n),3))
  rval$lr <- format(round(logtest, 2))
  rval$lr.df <- df
  rval$lr.p <- format(1 - pchisq(logtest,df))
  # Return the object
  rval
}

print.summary.coxph.penal <- function(x, digits = max(options()$digits - 4, 3), ...) {
  survival:::summary.coxph.penal(x$object)
}
