/* Set up for CBG CCC for PU17 processor */


#define target_int_mask 0xFFFFfffe

#define target_max_index 64     /* Biggest offset in indexed addressing */
#define target_int_size 2
#define leaders_in_text 0
#define target_ptr_size 2
#define immediate_mode_char '#'
#define target_local_delta 2         /* size of a variable on stack */
#define target_preg_name 7
#define target_max_pidx  126         /* largest offset in indexed mode */
#define max_denom 0x8000
#define target_locals_on_stackf 1
#define target_sof_overhead 4       /* i.e. first local at P[-4] */
#define target_autoextern 0
#define target_tot 2                /* Number of args passed in regs */

#define MAXDREG 6                   /* number of regs, excluding lr + sp */
#define MAXREG 7

#define BANNER_TEXT "cbgc PU16 C compiler"


/* Calling convention is
 *
 * R7 is P pointer.  Stack goes down. 
 *
 * All args are passed on stack except the first two which are in R0 and R1.
 * Result is in R0.
 *
 * On call, R2 contains new P pointer.
 *
 *   p[-4] is second local v
 *   p[-2] is first local v
 *   P[0] is old P
 *   p[2] is space to save RLA
 *   p[4] is space to save arg 1
 *   p[6] is space to save arg 2
 *   p[8] is actually arg 3 (3rd formal pram *)
 *
 *   THIS IS THE VERSION WITHOUT LDM STM
 *
 *      |                              current stack frame                 |   previous stack frame
 *  ----+--------+----------+----------+--------+---------+-------+--------+---------+-------
 * free |        |          |  local3  | local2 | local 1 | rla   |  old P |  ARG1   |
 *  ----+--------+----------+----------+--------+---------+-------+--------+---------+-------
 *      |             -10         -8       -6       -4        -2       ^   | 2
 *                                                                     |
 *                                                                   P = R7
 */ 
 
