//
// Kiwi Scientific Acceleration  
// University of Cambridge, Computer Laboratory
//
// vsys.v - A test wrapper for RTL_SIM test 
//
`timescale 1ns/1ns

module ACME_SIMSYS();
   reg clk, reset;
   initial begin reset = 1; clk = 0; #33 reset = 0; end
   always #5 clk = !clk;

   initial begin # (1000 * 1000) $display("Finish HDL simulation on timeout %t.", $time); $finish(); end
   initial begin $dumpfile("vcd.vcd"); $dumpvars(); end
   wire [31:0] waypoint;
   wire [7:0]  ksubsAbendSyndrome;
   wire [7:0]  ksubsGpioLeds;   
   reg [7:0]   finished_shifter;
   integer     clock_ticks;
   wire        finished = (ksubsAbendSyndrome != 0) && (ksubsAbendSyndrome != 128);
   //integer     pc_export;    

   wire [7:0]  ksubsManualWaypoint;

   DUT the_dut(.clk(clk), 
	       .reset(reset),
	       .ksubsManualWaypoint(ksubsManualWaypoint),
	       .ksubsAbendSyndrome(ksubsAbendSyndrome),
	       .ksubsGpioLeds(ksubsGpioLeds)
	       );

   always @(posedge clk) begin
	clock_ticks <= (reset) ?0: clock_ticks+1;
	finished_shifter = (reset)? 0: { finished_shifter, (finished_shifter[0]|finished) };
	if (finished_shifter[7]) begin
	   $display("Finished with code 0x%02h at %1t after %d clocks", ksubsAbendSyndrome, $time, clock_ticks);
	   $finish(0);
	   end
   end
   
endmodule
// eof


