// KiwiScientificAcceleration
// Testbenches Demo - August 2016.  University of Cambridge Computer Laboratory.
//
using System;
using KiwiSystem;

  
public class RiordanLikeTestBench
{
  [Kiwi.OutputBitPort("keyflag")]  static bool keyflag;
  [Kiwi.OutputBitPort("running")]  static bool running;
  [Kiwi.InputBitPort("start")]  static bool start;


  [Kiwi.InputWordPort("dinhi")]  static ulong dinhi;
  [Kiwi.InputWordPort("dinlo")]  static ulong dinlo;

  [Kiwi.InputWordPort("kinhi")]  static ulong kinhi;
  [Kiwi.InputWordPort("kinlo")]  static ulong kinlo;

  [Kiwi.OutputWordPort("douthi")]  static ulong douthi;
  [Kiwi.OutputWordPort("doutlo")]  static ulong doutlo;

  // Typically AES uses 16 byte (128 bit) blocks and a 128 bit key in CBC mode.
  static byte [] key   = new byte [16];
  static byte [] inv   = new byte [16];
  static byte [] outv  = new byte [16];

//  [Kiwi.HardwareEntryPoint()]
  public static void RiordanMain()
  {
    Console.WriteLine("Kiwi AES Demo RiordanLikeTestBench"); // This Test bench requires external control of start signal - it is not a unit test.
    Aes aes = new Aes();

    Console.WriteLine("WayPoint 1");
    const bool encf = false;

    // Create a Key and select enc or decrypt and ECB mode.
    AesTransformRef aesUnit1 = new AesTransformRef();
    // ----------------------    
    const bool timing = false;
    Console.WriteLine("WayPoint 2");
    while(true)
      {
	while (!start) Kiwi.Pause();
	keyflag = true;
	running = true;
	ulong kstart = 0;
	if (timing) kstart = Kiwi.tnow;
	Console.WriteLine("Start run");
	key[0] = (byte)(kinlo >> 0);     key[1] = (byte)(kinlo >> 8);     key[2] = (byte)(kinlo >> 16);     key[3] = (byte)(kinlo >> 24);
	key[4] = (byte)(kinlo >> 32);    key[5] = (byte)(kinlo >> 40);    key[6] = (byte)(kinlo >> 48);     key[7] = (byte)(kinlo >> 56);
	key[8] = (byte)(kinhi >> 0);     key[9] = (byte)(kinhi >> 8);     key[10] = (byte)(kinhi >> 16);    key[11] = (byte)(kinhi >> 24);
	key[12] = (byte)(kinhi >> 32);   key[13] = (byte)(kinhi >> 40);   key[14] = (byte)(kinhi >> 48);    key[15] = (byte)(kinhi >> 56);

	inv[0] = (byte)( dinlo >> 0);     inv[1] = (byte)(dinlo >> 8);     inv[2] = (byte)(dinlo >> 16);     inv[3] = (byte)(dinlo >> 24);
	inv[4] = (byte)( dinlo >> 32);    inv[5] = (byte)(dinlo >> 40);    inv[6] = (byte)(dinlo >> 48);     inv[7] = (byte)(dinlo >> 56);
	inv[8] = (byte)( dinhi >> 0);     inv[9] = (byte)(dinhi >> 8);     inv[10] = (byte)(dinhi >> 16);    inv[11] = (byte)(dinhi >> 24);
	inv[12] = (byte)(dinhi >> 32);    inv[13] = (byte)(dinhi >> 40);   inv[14] = (byte)(dinhi >> 48);    inv[15] = (byte)(dinhi >> 56);

	aesUnit1.InstallKey(aes, encf, key);

	Console.WriteLine("Key installed ({0} bytes).", key.Length);
	keyflag = false;
	if (timing) Console.WriteLine("Key Install Task took {0} ns (100MHz Clock)", Kiwi.tnow-kstart);


	aesUnit1.ECB(inv, outv);
	if (timing) Console.WriteLine("Task took {0} ns (100MHz Clock)", Kiwi.tnow-kstart);
	uint d0 = (uint)(outv[0]  + outv[1]*8  + outv[2]*16  + outv[3]*24);
	uint d1 = (uint)(outv[4]  + outv[5]*8  + outv[6]*16  + outv[7]*24);
	uint d2 = (uint)(outv[8]  + outv[9]*8  + outv[10]*16 + outv[11]*24);
	uint d3 = (uint)(outv[12] + outv[13]*8 + outv[14]*16 + outv[15]*24);
	doutlo = ((ulong)(d1) << 32) | ((ulong)(d0) << 0);
	douthi = ((ulong)(d3) << 32) | ((ulong)(d2) << 0);
	running = false;
	Console.Write("OUT: ");
	for (int j=0;j<outv.Length;j++) Console.Write("{0:X02} ", outv[j]);
	Console.WriteLine(); 	Console.WriteLine();	Console.WriteLine();
      }
//    Console.WriteLine("Kiwi AES Demo 2 Done at {0}, {1} tests.", Kiwi.tnow);
  }
}



public class GreavesTestBench
{
  // Typically AES uses 16 byte (128 bit) blocks and a 128 bit key in CBC mode.
  static byte [] key   = new byte [16];
  static byte [] inv   = new byte [16];
  static byte [] outv  = new byte [16];

  static void waypoint(int cycle, int no, string msg)
  {
    Kiwi.KppMark(no, msg);        
    Console.WriteLine("Waypoint {0} {1} {2}", cycle, no, msg);
    Kiwi.setGpioLeds8((byte)(no + cycle*16));
    Kiwi.Pause();
  }


 [Kiwi.HardwareEntryPoint()]
  public static void Main()
  {
    Console.WriteLine("Kiwi AES Demo 2 - Key=2, din=3,4,5");
    Aes aes = new Aes();

    bool encf = true;

    // Create a Key and select encrypt and ECB mode.
    AesTransformRef aesUnit1 = new AesTransformRef();
    waypoint(0, 2, "START-KEY-CREATE");
    for (int p=0; p<key.Length;p++) key[p] = (byte)(p==15? 2:0); 
    waypoint(0, 3, "START-KEY-INSTALL");
    aesUnit1.InstallKey(aes, encf, key); 

    string msg = (encf) ? "Encrypt": "Decrypt";
    Console.WriteLine("Key installed {0} ({1} bytes).", msg, key.Length);
    for (int test_no=0; test_no<3; test_no++)
      {
        waypoint(test_no, 4, "START-DATA-GEN");
	for (int p=0; p<16;p++) inv[p] = (byte)(p==15?3+test_no:0);  // Create input data
	Console.Write("IN:  ");
	for (int j=0;j<outv.Length;j++) Console.Write("{0:X02} ", inv[j]);
	Console.WriteLine();
        waypoint(test_no, 5, "START-DATA-ENCRYPT");
	aesUnit1.ECB(inv, outv);
        waypoint(test_no, 6, "STOP-DATA-ENCRYPT");
	Console.Write("OUT: ");
	for (int j=0;j<outv.Length;j++) Console.Write("{0:X02} ", outv[j]);
	Console.WriteLine();
	Console.WriteLine();
	Console.WriteLine();
      }
    waypoint(0, 7, "STOP-ALL");
    Console.WriteLine("Kiwi AES Demo 2 Done at {0}", Kiwi.tnow);
    Kiwi.Pause();
    Kiwi.ReportNormalCompletion();
    Kiwi.Pause();

  }

  public static void OldMain()
  {
    Console.WriteLine("Kiwi AES Demo - Hello");
    Aes aes = new Aes();
    Kiwi.KppMark(2, "START-KEY-CREATE");
    // Create a Key and select encrypt and ECB mode.
    AesTransformRef aesUnit1 = new AesTransformRef();
    for (int p=0; p<key.Length;p++) key[p] = (byte)(p+64); 
    Kiwi.KppMark(3, "START-KEY-INSTALL");
    aesUnit1.InstallKey(aes, true, key); // Encrypt

    Console.WriteLine("Key installed ({0} bytes).", key.Length);

    Kiwi.KppMark(199, "START-DATA-ENCRYPT");
    int no_of_tests = 3;
    for (int test_no=0; test_no<no_of_tests; test_no++)
      {
	for (int p=0; p<16;p++) inv[p] = (byte)(p+16);  // Create input data
        inv[0] = (byte)(test_no*3);
	Console.Write("IN:  ");
	for (int j=0;j<outv.Length;j++) Console.Write("{0:X02} ", inv[j]);
	Console.WriteLine();
	aesUnit1.ECB(inv, outv);
        Kiwi.Pause();
	Console.Write("OUT: ");
	for (int j=0;j<outv.Length;j++) Console.Write("{0:X02} ", outv[j]);
	Console.WriteLine();
      }
    Console.WriteLine("Kiwi AES Old Demo Done at {0}. {1} tests.", Kiwi.tnow, no_of_tests);
    Kiwi.Pause();
    Kiwi.ReportNormalCompletion();
    Kiwi.Pause();
  }
}



// eof
