theory Wasm_Type_Abs_Printing imports Main "../Wasm" "$ISABELLE_HOME/src/HOL/Library/Code_Target_Nat" begin

typedecl int32_impl
typedecl int64_impl
typedecl float32_impl  
typedecl float64_impl

instantiation int32_impl :: wasm_int begin instance .. end
instantiation int64_impl :: wasm_int begin instance .. end
instantiation float32_impl :: wasm_float begin instance .. end
instantiation float64_impl :: wasm_float begin instance .. end

consts
  int32_impl_itself :: "int32_impl itself"
  int64_impl_itself :: "int64_impl itself"
  float32_impl_itself :: "float32_impl itself"
  float64_impl_itself :: "float64_impl itself"

consts
  (* inter-type conversions *)
    (* float to i32 *)
  ui32_trunc_f32_impl :: "float32_impl \<Rightarrow> int32_impl option"
  si32_trunc_f32_impl :: "float32_impl \<Rightarrow> int32_impl option"
  ui32_trunc_f64_impl :: "float64_impl \<Rightarrow> int32_impl option"
  si32_trunc_f64_impl :: "float64_impl \<Rightarrow> int32_impl option"
    (* float to i64 *)
  ui64_trunc_f32_impl :: "float32_impl \<Rightarrow> int64_impl option"
  si64_trunc_f32_impl :: "float32_impl \<Rightarrow> int64_impl option"
  ui64_trunc_f64_impl :: "float64_impl \<Rightarrow> int64_impl option"
  si64_trunc_f64_impl :: "float64_impl \<Rightarrow> int64_impl option"
    (* int to f32 *)
  f32_convert_ui32_impl :: "int32_impl \<Rightarrow> float32_impl"
  f32_convert_si32_impl :: "int32_impl \<Rightarrow> float32_impl"
  f32_convert_ui64_impl :: "int64_impl \<Rightarrow> float32_impl"
  f32_convert_si64_impl :: "int64_impl \<Rightarrow> float32_impl"
    (* int to f64 *)
  f64_convert_ui32_impl :: "int32_impl \<Rightarrow> float64_impl"
  f64_convert_si32_impl :: "int32_impl \<Rightarrow> float64_impl"
  f64_convert_ui64_impl :: "int64_impl \<Rightarrow> float64_impl"
  f64_convert_si64_impl :: "int64_impl \<Rightarrow> float64_impl"
  (* intra-type conversions *)
  wasm_wrap_impl :: "int64_impl \<Rightarrow> int32_impl"
  wasm_extend_u_impl :: "int32_impl \<Rightarrow> int64_impl"
  wasm_extend_s_impl :: "int32_impl \<Rightarrow> int64_impl"
  wasm_demote_impl :: "float64_impl \<Rightarrow> float32_impl"
  wasm_promote_impl :: "float32_impl \<Rightarrow> float64_impl"

(* Maps types to Andreas' Ocaml implementation - a thin wrapper over Ocaml ints/floats for the most part. *)

code_printing
  type_constructor int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.t"
| type_constructor int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.t"
| type_constructor float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.t"
| type_constructor float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.t"

(* zero consts *)
code_printing
  constant zero_int32_impl_inst.zero_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.zero"
| constant zero_int64_impl_inst.zero_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.zero"
| constant zero_float32_impl_inst.zero_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.zero"
| constant zero_float64_impl_inst.zero_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.zero"

(* intra-{int,float} conversions *)
code_printing
  constant wasm_wrap_impl \<rightharpoonup> (OCaml) "(I32Wrapper'_convert.wrap'_i64)"
| constant wasm_extend_u_impl \<rightharpoonup> (OCaml) "(I64Wrapper'_convert.extend'_u'_i32)"
| constant wasm_extend_s_impl \<rightharpoonup> (OCaml) "(I64Wrapper'_convert.extend'_s'_i32)"
| constant wasm_demote_impl \<rightharpoonup> (OCaml) "(F32Wrapper'_convert.demote'_f64)"
| constant wasm_promote_impl \<rightharpoonup> (OCaml) "(F64Wrapper'_convert.promote'_f32)"

(* arithmetic *)
code_printing
(* INT32 *)
  (* UNOPS *)
  constant wasm_int_int32_impl_inst.int_clz_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.clz"
| constant wasm_int_int32_impl_inst.int_ctz_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.ctz"
| constant wasm_int_int32_impl_inst.int_popcnt_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.popcnt"
  (* BINOPS - wrap *)
| constant wasm_int_int32_impl_inst.int_add_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.add"
| constant wasm_int_int32_impl_inst.int_sub_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.sub"
| constant wasm_int_int32_impl_inst.int_mul_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.mul"
| constant wasm_int_int32_impl_inst.int_div_u_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.div'_u"
| constant wasm_int_int32_impl_inst.int_div_s_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.div'_s"
| constant wasm_int_int32_impl_inst.int_rem_u_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.rem'_u"
| constant wasm_int_int32_impl_inst.int_rem_s_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.rem'_s"
| constant wasm_int_int32_impl_inst.int_and_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.and'_"
| constant wasm_int_int32_impl_inst.int_or_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.or'_"
| constant wasm_int_int32_impl_inst.int_xor_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.xor"
| constant wasm_int_int32_impl_inst.int_shl_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.shl"
| constant wasm_int_int32_impl_inst.int_shr_u_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.shr'_u"
| constant wasm_int_int32_impl_inst.int_shr_s_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.shr'_s"
| constant wasm_int_int32_impl_inst.int_rotl_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.rotl"
| constant wasm_int_int32_impl_inst.int_rotr_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.rotr"
  (* TESTOPS *)
| constant wasm_int_int32_impl_inst.int_eqz_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.eqz"
  (* RELOPS *)
| constant wasm_int_int32_impl_inst.int_eq_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.eq"
| constant wasm_int_int32_impl_inst.int_lt_u_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.lt'_u"
| constant wasm_int_int32_impl_inst.int_lt_s_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.lt'_s"
| constant wasm_int_int32_impl_inst.int_gt_u_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.gt'_u"
| constant wasm_int_int32_impl_inst.int_gt_s_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.gt'_s"
| constant wasm_int_int32_impl_inst.int_le_u_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.le'_u"
| constant wasm_int_int32_impl_inst.int_le_s_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.le'_s"
| constant wasm_int_int32_impl_inst.int_ge_u_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.ge'_u"
| constant wasm_int_int32_impl_inst.int_ge_s_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.ge'_s"
  (* CONVERSIONS *)
| constant f32_convert_ui32_impl \<rightharpoonup> (OCaml) "F32Wrapper'_convert.convert'_u'_i32"
| constant f32_convert_si32_impl \<rightharpoonup> (OCaml) "F32Wrapper'_convert.convert'_s'_i32"
| constant f64_convert_ui32_impl \<rightharpoonup> (OCaml) "F64Wrapper'_convert.convert'_u'_i32"
| constant f64_convert_si32_impl \<rightharpoonup> (OCaml) "F64Wrapper'_convert.convert'_s'_i32"
  (* VALUE CONVERSIONS - wrap *)
| constant wasm_int_int32_impl_inst.int_of_nat_int32_impl \<rightharpoonup> (OCaml) "I32Wrapper.int32'_of'_big'_int (Arith.integer'_of'_nat _)"
| constant wasm_int_int32_impl_inst.nat_of_int_int32_impl \<rightharpoonup> (OCaml) "Arith.Nat (I32Wrapper.big'_int'_of'_int32 _)"
  (* SIGN EXTENDING DESERIALISATION TODO *)

(* INT64 *)
  (* UNOPS *)
| constant wasm_int_int64_impl_inst.int_clz_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.clz"
| constant wasm_int_int64_impl_inst.int_ctz_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.ctz"
| constant wasm_int_int64_impl_inst.int_popcnt_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.popcnt"
  (* BINOPS - wrap *)
| constant wasm_int_int64_impl_inst.int_add_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.add"
| constant wasm_int_int64_impl_inst.int_sub_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.sub"
| constant wasm_int_int64_impl_inst.int_mul_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.mul"
| constant wasm_int_int64_impl_inst.int_div_u_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.div'_u"
| constant wasm_int_int64_impl_inst.int_div_s_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.div'_s"
| constant wasm_int_int64_impl_inst.int_rem_u_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.rem'_u"
| constant wasm_int_int64_impl_inst.int_rem_s_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.rem'_s"
| constant wasm_int_int64_impl_inst.int_and_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.and'_"
| constant wasm_int_int64_impl_inst.int_or_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.or'_"
| constant wasm_int_int64_impl_inst.int_xor_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.xor"
| constant wasm_int_int64_impl_inst.int_shl_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.shl"
| constant wasm_int_int64_impl_inst.int_shr_u_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.shr'_u"
| constant wasm_int_int64_impl_inst.int_shr_s_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.shr'_s"
| constant wasm_int_int64_impl_inst.int_rotl_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.rotl"
| constant wasm_int_int64_impl_inst.int_rotr_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.rotr"
  (* TESTOPS *)
| constant wasm_int_int64_impl_inst.int_eqz_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.eqz"
  (* RELOPS *)
| constant wasm_int_int64_impl_inst.int_eq_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.eq"
| constant wasm_int_int64_impl_inst.int_lt_u_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.lt'_u"
| constant wasm_int_int64_impl_inst.int_lt_s_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.lt'_s"
| constant wasm_int_int64_impl_inst.int_gt_u_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.gt'_u"
| constant wasm_int_int64_impl_inst.int_gt_s_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.gt'_s"
| constant wasm_int_int64_impl_inst.int_le_u_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.le'_u"
| constant wasm_int_int64_impl_inst.int_le_s_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.le'_s"
| constant wasm_int_int64_impl_inst.int_ge_u_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.ge'_u"
| constant wasm_int_int64_impl_inst.int_ge_s_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.ge'_s"
  (* CONVERSIONS *)
| constant f32_convert_ui64_impl \<rightharpoonup> (OCaml) "F32Wrapper'_convert.convert'_u'_i64"
| constant f32_convert_si64_impl \<rightharpoonup> (OCaml) "F32Wrapper'_convert.convert'_s'_i64"
| constant f64_convert_ui64_impl \<rightharpoonup> (OCaml) "F64Wrapper'_convert.convert'_u'_i64"
| constant f64_convert_si64_impl \<rightharpoonup> (OCaml) "F64Wrapper'_convert.convert'_s'_i64"
  (* VALUE CONVERSIONS - wrap *)
| constant wasm_int_int64_impl_inst.int_of_nat_int64_impl \<rightharpoonup> (OCaml) "I64Wrapper.int64'_of'_big'_int (Arith.integer'_of'_nat _)"
| constant wasm_int_int64_impl_inst.nat_of_int_int64_impl \<rightharpoonup> (OCaml) "Arith.Nat (I64Wrapper.big'_int'_of'_int64 _)"
  (* SIGN EXTENDING DESERIALISATION TODO *)

(* FLOAT32 *)
  (* UNOPS *)
| constant wasm_float_float32_impl_inst.float_neg_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.neg"
| constant wasm_float_float32_impl_inst.float_abs_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.abs"
| constant wasm_float_float32_impl_inst.float_ceil_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.ceil"
| constant wasm_float_float32_impl_inst.float_floor_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.floor"
| constant wasm_float_float32_impl_inst.float_trunc_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.trunc"
| constant wasm_float_float32_impl_inst.float_nearest_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.nearest"
| constant wasm_float_float32_impl_inst.float_sqrt_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.sqrt"
  (* BINOPS *)
| constant wasm_float_float32_impl_inst.float_add_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.add"
| constant wasm_float_float32_impl_inst.float_sub_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.sub"
| constant wasm_float_float32_impl_inst.float_mul_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.mul"
| constant wasm_float_float32_impl_inst.float_div_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.div"
| constant wasm_float_float32_impl_inst.float_min_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.min"
| constant wasm_float_float32_impl_inst.float_max_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.max"
| constant wasm_float_float32_impl_inst.float_copysign_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.copysign"
  (* RELOPS *)
| constant wasm_float_float32_impl_inst.float_eq_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.eq"
(* | constant wasm_float_float32_impl_inst.float_ne_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.ne" *)
| constant wasm_float_float32_impl_inst.float_lt_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.lt"
| constant wasm_float_float32_impl_inst.float_gt_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.gt"
| constant wasm_float_float32_impl_inst.float_le_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.le"
| constant wasm_float_float32_impl_inst.float_ge_float32_impl \<rightharpoonup> (OCaml) "F32Wrapper.ge"
  (* CONVERSIONS *)
| constant ui32_trunc_f32_impl \<rightharpoonup> (OCaml) "I32Wrapper'_convert.trunc'_u'_f32"
| constant si32_trunc_f32_impl \<rightharpoonup> (OCaml) "I32Wrapper'_convert.trunc'_s'_f32"
| constant ui64_trunc_f32_impl \<rightharpoonup> (OCaml) "I64Wrapper'_convert.trunc'_u'_f32"
| constant si64_trunc_f32_impl \<rightharpoonup> (OCaml) "I64Wrapper'_convert.trunc'_s'_f32"
(* FLOAT64 *)
  (* UNOPS *)
| constant wasm_float_float64_impl_inst.float_neg_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.neg"
| constant wasm_float_float64_impl_inst.float_abs_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.abs"
| constant wasm_float_float64_impl_inst.float_ceil_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.ceil"
| constant wasm_float_float64_impl_inst.float_floor_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.floor"
| constant wasm_float_float64_impl_inst.float_trunc_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.trunc"
| constant wasm_float_float64_impl_inst.float_nearest_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.nearest"
| constant wasm_float_float64_impl_inst.float_sqrt_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.sqrt"
  (* BINOPS *)
| constant wasm_float_float64_impl_inst.float_add_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.add"
| constant wasm_float_float64_impl_inst.float_sub_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.sub"
| constant wasm_float_float64_impl_inst.float_mul_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.mul"
| constant wasm_float_float64_impl_inst.float_div_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.div"
| constant wasm_float_float64_impl_inst.float_min_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.min"
| constant wasm_float_float64_impl_inst.float_max_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.max"
| constant wasm_float_float64_impl_inst.float_copysign_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.copysign"
  (* RELOPS *)
| constant wasm_float_float64_impl_inst.float_eq_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.eq"
(* | constant wasm_float_float64_impl_inst.float_ne_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.ne" *)
| constant wasm_float_float64_impl_inst.float_lt_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.lt"
| constant wasm_float_float64_impl_inst.float_gt_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.gt"
| constant wasm_float_float64_impl_inst.float_le_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.le"
| constant wasm_float_float64_impl_inst.float_ge_float64_impl \<rightharpoonup> (OCaml) "F64Wrapper.ge"
  (* CONVERSIONS *)
| constant ui32_trunc_f64_impl \<rightharpoonup> (OCaml) "I32Wrapper'_convert.trunc'_u'_f64"
| constant si32_trunc_f64_impl \<rightharpoonup> (OCaml) "I32Wrapper'_convert.trunc'_s'_f64"
| constant ui64_trunc_f64_impl \<rightharpoonup> (OCaml) "I64Wrapper'_convert.trunc'_u'_f64"
| constant si64_trunc_f64_impl \<rightharpoonup> (OCaml) "I64Wrapper'_convert.trunc'_s'_f64"

(* memory *)

typedecl bits_impl
typedecl heap_impl

axiomatization
 mem_size_impl :: "heap_impl \<Rightarrow> nat" and
 mem_grow_impl :: "heap_impl \<Rightarrow> nat \<Rightarrow> heap_impl option" and
 load_impl :: "heap_impl \<Rightarrow> nat \<Rightarrow> off \<Rightarrow> nat \<Rightarrow> bits_impl option" and
 store_impl :: "heap_impl \<Rightarrow> nat \<Rightarrow> off \<Rightarrow> bits_impl => nat \<Rightarrow> heap_impl option" and
 load_packed_impl :: "sx \<Rightarrow> heap_impl \<Rightarrow> nat \<Rightarrow> off \<Rightarrow> nat \<Rightarrow> bits_impl option" and
 store_packed_impl :: "heap_impl \<Rightarrow> nat \<Rightarrow> off \<Rightarrow> bits_impl \<Rightarrow> nat \<Rightarrow> heap_impl option"
where
 mem_grow_impl_correct: "\<And>m n m'. mem_grow_impl m n = Some m' \<Longrightarrow> mem_size_impl m \<le> mem_size_impl m'" and
 store_impl_correct: "\<And>m n off v l m'. store_impl m n off v l = Some m' \<Longrightarrow> mem_size_impl m = mem_size_impl m'" and
 store_packed_impl_correct: "\<And>m n off v l m'. store_packed_impl m n off v l = Some m' \<Longrightarrow> mem_size_impl m = mem_size_impl m'"

axiomatization
  serialise_i32_impl :: "int32_impl \<Rightarrow> bits_impl" and
  serialise_i64_impl :: "int64_impl \<Rightarrow> bits_impl" and
  serialise_f32_impl :: "float32_impl \<Rightarrow> bits_impl" and
  serialise_f64_impl :: "float64_impl \<Rightarrow> bits_impl" and
  wasm_deserialise_impl :: "bits_impl \<Rightarrow> t \<Rightarrow> (int32_impl, int64_impl, float32_impl, float64_impl) v" and
  wasm_bool_impl :: "bool \<Rightarrow> int32_impl" and
  int32_minus_one_impl :: int32_impl
where
   wasm_deserialise_impl_correct: "\<And>bs t. typeof (wasm_deserialise_impl bs t) = t"

code_printing
  type_constructor bits_impl \<rightharpoonup> (OCaml) "Int64.t"
| type_constructor heap_impl \<rightharpoonup> (OCaml) "ImplWrapperTypes.memory"

code_printing
  constant mem_size_impl \<rightharpoonup> (OCaml) "ImplWrapper.size"
| constant mem_grow_impl \<rightharpoonup> (OCaml) "ImplWrapper.grow"
| constant load_impl \<rightharpoonup> (OCaml) "ImplWrapper.load"
| constant store_impl \<rightharpoonup> (OCaml) "ImplWrapper.store"
| constant load_packed_impl \<rightharpoonup> (OCaml) "ImplWrapper.load'_packed"
| constant store_packed_impl \<rightharpoonup> (OCaml) "ImplWrapper.store'_packed"

code_printing
  constant serialise_i32_impl \<rightharpoonup> (OCaml) "Int64.of'_int32"
| constant serialise_i64_impl \<rightharpoonup> (OCaml) "(fun i -> i)"
| constant serialise_f32_impl \<rightharpoonup> (OCaml) "(Int64.of'_int32 (F32Wrapper.to'_bits _))"
| constant serialise_f64_impl \<rightharpoonup> (OCaml) "F64Wrapper.to'_bits"
| constant wasm_deserialise_impl \<rightharpoonup> (OCaml) "ImplWrapper.deserialise"
| constant wasm_bool_impl \<rightharpoonup> (OCaml) "ImplWrapper.bool"
| constant int32_minus_one_impl \<rightharpoonup> (OCaml) "I32Wrapper.minus'_one"

(* host *)

typedecl host_function_impl

consts
  host_function_impl_itself :: "host_function_impl itself"

axiomatization
  host_apply_impl ::  "(int32_impl,int64_impl,float32_impl,float64_impl,heap_impl,host_function_impl) s \<Rightarrow> tf \<Rightarrow> host_function_impl \<Rightarrow> (int32_impl,int64_impl,float32_impl,float64_impl) v list \<Rightarrow> (((int32_impl,int64_impl,float32_impl,float64_impl,heap_impl,host_function_impl) s) \<times> (int32_impl,int64_impl,float32_impl,float64_impl) v list) option"
where
  host_apply_impl_correct_1:"list_all2 types_agree t1s vs \<Longrightarrow> host_apply_impl s tf f vs = Some (s', vs') \<Longrightarrow> store_extension s s'" and
  host_apply_impl_correct_2:"list_all2 types_agree t1s vs \<Longrightarrow> host_apply_impl s (t1s _> t2s) f vs = Some (s', vs') \<Longrightarrow> list_all2 types_agree t2s vs'"

code_printing
  type_constructor host_function_impl \<rightharpoonup> (OCaml) "ImplWrapperTypes.host'_function'_t"

code_printing
  constant host_apply_impl  \<rightharpoonup> (OCaml) "ImplWrapper.host'_apply"

end