theory Wasm_Interpreter_Printing imports Main "Wasm_Interpreter_Properties" "Wasm_Type_Abs/Wasm_Type_Abs_Printing" begin

lemma wasm_execution_impl: "wasm_execution
                              mem_size_impl
                              mem_grow_impl
                              store_impl
                              store_packed_impl
                              host_apply_impl
                              wasm_deserialise_impl"
  using mem_grow_impl_correct
        store_impl_correct
        store_packed_impl_correct
        host_apply_impl_correct_1
        host_apply_impl_correct_2
        wasm_deserialise_impl_correct
  by unfold_locales simp_all

global_interpretation wasm_execution_ocaml: wasm_execution
  int32_impl_itself
  int64_impl_itself
  float32_impl_itself
  float64_impl_itself
  mem_size_impl
  mem_grow_impl
  load_impl
  store_impl
  load_packed_impl
  store_packed_impl
  host_function_impl_itself
  host_apply_impl
  ui32_trunc_f32_impl
  si32_trunc_f32_impl
  ui32_trunc_f64_impl
  si32_trunc_f64_impl
  ui64_trunc_f32_impl
  si64_trunc_f32_impl
  ui64_trunc_f64_impl
  si64_trunc_f64_impl
  f32_convert_ui32_impl
  f32_convert_si32_impl
  f32_convert_ui64_impl
  f32_convert_si64_impl
  f64_convert_ui32_impl
  f64_convert_si32_impl
  f64_convert_ui64_impl
  f64_convert_si64_impl
  wasm_wrap_impl
  wasm_extend_u_impl
  wasm_extend_s_impl
  wasm_demote_impl
  wasm_promote_impl
  serialise_i32_impl
  serialise_i64_impl
  serialise_f32_impl
  serialise_f64_impl
  wasm_deserialise_impl
  wasm_bool_impl
  int32_minus_one_impl
defines wasm_execution_ocaml_n_zeros = wasm_execution_ocaml.n_zeros
    and wasm_execution_ocaml_bitzero = wasm_execution_ocaml.bitzero
    and wasm_execution_ocaml_smem_ind = wasm_execution_ocaml.smem_ind
    and wasm_execution_ocaml_bits = wasm_execution_ocaml.bits
    and wasm_execution_ocaml_cvt = wasm_execution_ocaml.cvt
    and wasm_execution_ocaml_cvt_i32 = wasm_execution_ocaml.cvt_i32
    and wasm_execution_ocaml_cvt_i64 = wasm_execution_ocaml.cvt_i64
    and wasm_execution_ocaml_cvt_f32 = wasm_execution_ocaml.cvt_f32
    and wasm_execution_ocaml_cvt_f64 = wasm_execution_ocaml.cvt_f64
    and wasm_execution_ocaml_run_v = wasm_execution_ocaml.run_v
    and wasm_execution_ocaml_run_step = wasm_execution_ocaml.run_step
    and wasm_execution_ocaml_run_one_step = wasm_execution_ocaml.run_one_step
    and wasm_execution_ocaml_e_is_trap = wasm_execution_ocaml.e_is_trap
    and wasm_execution_ocaml_es_is_trap = wasm_execution_ocaml.es_is_trap
by (rule wasm_execution_impl)

definition "run = wasm_execution_ocaml.run_v (2^63) 300"
end