#!/bin/bash
value=`cat ../Model/WASM_extracted/interpreter.ml`
regex="(.*)(module Wasm_Checker_Printing : sig.*)(module Wasm_Type_Abs_Printing : sig.*)(module Wasm_Interpreter_Printing : sig.*)"
if [[ $value =~ $regex ]]
then
    interpreterAux="${BASH_REMATCH[1]}${BASH_REMATCH[3]}"
    checker=${BASH_REMATCH[2]}
    interpreter=${BASH_REMATCH[4]}

    echo -e "$interpreterAux" > Verified_Interpreter/interpreterAux.ml
    echo -e "open InterpreterAux\n\n$checker" > Verified_Interpreter/checker.ml
    echo -e "open InterpreterAux\n\n$interpreter" > Verified_Interpreter/interpreter.ml
else
    echo "Couldn't find generated code! Did the extraction complete successfully?" >&2
fi
