include Int.Make
  (struct
    include Int32
    let bitwidth = 32
  end)

let add x y = Some (add x y)
let sub x y = Some (sub x y)
let mul x y = Some (mul x y)

let div_u x y = try Some (div_u x y) with _ -> None
let div_s x y = try Some (div_s x y) with _ -> None
let rem_u x y = try Some (rem_u x y) with _ -> None
let rem_s x y = try Some (rem_s x y) with _ -> None

let and_ x y = Some (and_ x y)
let or_ x y = Some (or_ x y)
let xor x y = Some (xor x y)
let shl x y = Some (shl x y)
let shr_u x y = Some (shr_u x y)
let shr_s x y = Some (shr_s x y)
let rotl x y = Some (rotl x y)
let rotr x y = Some (rotr x y)

let int32_of_big_int x = Big_int.int32_of_big_int x
let big_int_of_int32 x = Big_int.big_int_of_string (I32.to_string_u x)

let minus_one = Int32.minus_one
