/*
The port of TinySec to the MICAz motes is
 (c) 2007-2008 University of Cambridge
 
  The original source code was adapted for the use of TinySec library
  on MICAz motes by Matt Lewis and Dan Cvrcek as part of
     WINES II - Smart Infrastructure EPSRC Project EP/D076870/1
     http://www.winesinfrastructure.org/
  The security-related part of this project was led by Frank Stajano.
  None of the above parties will provide support for this port.
 
  This port is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see http://www.gnu.org/licenses/.

  Parts of the code are subject of Moteworks 2.0 license. 
  See license.txt file in the MoteWorks distribution for details.
*/
/*
 * Copyright (c) 2002-2005 Intel Corporation
 * Copyright (c) 2000-2005 The Regents of the University of California
 * All rights reserved.
 * See license.txt file included with the distribution.
 *
 * $Id: AM.h,v 1.1.2.2 2007/04/27 04:56:22 njain Exp $
 */

/*
 *
 * Authors:		Jason Hill, David Gay, Philip Levis, Chris Karlof
 * Date last modified:  6/25/02
 *
 */

// Message format


/**
 * @author Jason Hill
 * @author David Gay
 * @author Philip Levis
 * @author Chris Karlof
 */
/*****************************************************************************
$Log: AM.h,v $
Revision 1.1.2.2  2007/04/27 04:56:22  njain
CVS: Please enter a Bugzilla bug number on the next line.
BugID: 1100

CVS: Please enter the commit log message below.
License header modified in each file for MoteWorks_2_0_F release

Revision 1.1.2.1  2007/01/12 11:06:46  lwei
CVS: Please enter a Bugzilla bug number on the next line.
BugID:
CVS: Please enter the commit log message below.
1.  Commit the 2.0.E RC1 version for new M2110 M2100 M9100 M4100 Platform, it need to use the new toolchain for 1281 and RF230.
CVS: ----------------------------------------------------------------------
CVS: Enter Log. Lines beginning with `CVS:' are removed automatically
CVS:
CVS: Committing in <DIRECTORY NAME>
CVS:
CVS: Modified Files:
CVS: Tag: MoteWorks_2_0_RELEASE_BRANCH
CVS: <FILE1> <FILE2> ... <FILEn>
CVS: ----------------------------------------------------------------------

Revision 1.3  2006/02/17 01:47:26  nxu
make TOS_AM_GROUP extern for XMesh binary

Revision 1.2  2006/01/07 01:14:51  rkapur
Changed AMPromiscous to allow TOS_BCAST_GROUP pass through and defined the var in AM.h

Revision 1.1  2006/01/03 07:46:18  mturon
Initial install of MoteWorks tree

Revision 1.2  2005/03/02 22:40:44  jprabhu
Deleted MICAZOLD compiler directives

*****************************************************************************/
#ifndef AM_H_INCLUDED
#define AM_H_INCLUDED

enum {
  TOS_BCAST_ADDR = 0xffff,
  TOS_UART_ADDR = 0x007e,
};

//#ifndef TOS_BCAST_ADDR
//#define TOS_BCAST_ADDR  0xffff
//#endif
//#define TOS_UART_ADDR   0x007e

//RK - change for XJoin
#define TOS_BCAST_GROUP  0xFF
//RK - end change


#ifndef DEF_TOS_AM_GROUP
#define DEF_TOS_AM_GROUP 0x7d
#endif

enum {
  TOS_DEFAULT_AM_GROUP = DEF_TOS_AM_GROUP
};

#ifndef NESC_BUILD_BINARY
uint8_t TOS_AM_GROUP = TOS_DEFAULT_AM_GROUP;
#else
extern uint8_t TOS_AM_GROUP;
#endif

#ifndef TOSH_DATA_LENGTH
#define TOSH_DATA_LENGTH 29
#endif

#ifndef TOSH_AM_LENGTH
#define TOSH_AM_LENGTH 1
#endif

#ifndef TINYSEC_MAC_LENGTH
#define TINYSEC_MAC_LENGTH 4
#endif

#ifndef TINYSEC_IV_LENGTH
#define TINYSEC_IV_LENGTH 4
#endif

#ifndef TINYSEC_ACK_LENGTH
#define TINYSEC_ACK_LENGTH 1
#endif
typedef struct TOS_Msg
{
  /* The following fields are transmitted/received on the radio. */
  uint8_t length;
  uint8_t fcfhi;
  uint8_t fcflo;
  uint8_t dsn;
  uint16_t destpan;
  uint16_t addr;
  uint8_t type;
  uint8_t group;

  /*
   * Ensure that a TOS_Msg is large enough to hold any message we might wish to
   * store in it (including a TinySec message).  The magic 7 here is the number
   * of bytes in this structure after the data field.
   */

  int8_t data[TOSH_DATA_LENGTH+TINYSEC_IV_LENGTH+TINYSEC_MAC_LENGTH+TINYSEC_ACK_LENGTH-7];

  /* The following fields are not actually transmitted or received
   * on the radio! They are used for internal accounting only.
   * The reason they are in this structure is that the AM interface
   * requires them to be part of the TOS_Msg that is passed to
   * send/receive operations.
   */
  uint8_t strength;
  uint8_t receiveSecurityMode;
  uint8_t sendSecurityMode;
  uint8_t lqi;
  bool crc;
  uint8_t ack;
  uint16_t time;
} TOS_Msg;

typedef struct TOS_Msg_TinySecCompat
{
  uint8_t length;
  uint8_t fcfhi;
  uint8_t fcflo;
  uint8_t dsn;
  uint16_t destpan;
  uint16_t addr;
  uint8_t type;
  uint8_t group;  // This field not transmitted over radio
  int8_t data[TOSH_DATA_LENGTH+TINYSEC_IV_LENGTH+TINYSEC_MAC_LENGTH+TINYSEC_ACK_LENGTH-7];
  uint8_t strength;
  uint8_t receiveSecurityMode;
  uint8_t sendSecurityMode;
  uint8_t lqi;
  bool crc;
  uint8_t ack;
  uint16_t time;
} TOS_Msg_TinySecCompat;

typedef struct TinySec_Msg
{
  uint16_t addr;
  uint8_t type;
  uint8_t length;

  // Encryption IV
  uint8_t iv[TINYSEC_IV_LENGTH];

  // Encrypted data
  uint8_t enc[TOSH_DATA_LENGTH];

  // Message authentication code
  uint8_t mac[TINYSEC_MAC_LENGTH];

  // not transmitted - used only by MHSRTinySec
  uint8_t calc_mac[TINYSEC_MAC_LENGTH];
  uint8_t ack_byte;
  bool cryptoDone;
  bool receiveDone;
  // indicates whether the calc_mac field has been computed
  bool MACcomputed;
} __attribute__((packed))  TinySec_Msg;

enum {
  // size of the header NOT including the length byte
  MSG_HEADER_SIZE = offsetof(struct TOS_Msg, data) - 1,	  //(2+1+2+2)+(TOSHeader=5)=11
  // size of the footer
  MSG_FOOTER_SIZE = 2,
  // size of the full packet-including length byte
  MSG_DATA_SIZE = offsetof(struct TOS_Msg, strength) + sizeof(uint16_t), //1+7+5+29+1+2
  TINYSEC_MSG_DATA_SIZE = offsetof(struct TinySec_Msg, mac) + TINYSEC_MAC_LENGTH,
  TINYSEC_HEADER_SIZE = offsetof(TinySec_Msg, iv),
  // size of the data length
  DATA_LENGTH = TOSH_DATA_LENGTH,
  // position of the length byte
  LENGTH_BYTE_NUMBER = offsetof(struct TOS_Msg, length) + 1,
  // size of MAC Header
  TOS_HEADER_SIZE = 5, 	   //TOSHeader=addr(2)+type(1)+groupid(1)+length(1)
  TINYSEC_NODE_ID_SIZE = sizeof(uint16_t)
};

enum
{
  TINYSEC_AUTH_ONLY = 1,
  TINYSEC_ENCRYPT_AND_AUTH = 2,
  TINYSEC_DISABLED = 3,
  TINYSEC_RECEIVE_AUTHENTICATED = 4,
  TINYSEC_RECEIVE_CRC = 5,
  TINYSEC_RECEIVE_ANY = 6,
  TINYSEC_ENABLED_BIT = 128,
  TINYSEC_ENCRYPT_ENABLED_BIT = 64,
  ENCRYPT_SHIFT = 3
} __attribute__((packed));

typedef TOS_Msg *TOS_MsgPtr;

uint8_t TOS_MsgLength(uint8_t type)
{
#if 0
  uint8_t i;

  for (i = 0; i < MSGLEN_TABLE_SIZE; i++)
    if (msgTable[i].handler == type)
      return msgTable[i].length;
#endif

  return offsetof(TOS_Msg, crc);
}
#endif
