import numpy as np
import chipwhisperer as cw
import time
import sys
import KECCAK
class Test:
  def __init__(self, FCPU = 0):
    self.log = []
    self.scope = cw.scope()
    self.scope.default_setup()
    self.scope.clock.freq_ctr_src = 'clkgen'
    time.sleep(1)
    print(self.scope.clock.freq_ctr)
    print(self.scope.clock.clkgen_mul, self.scope.clock.clkgen_div)
    cw.program_target(self.scope, cw.programmers.STM32FProgrammer, "./simpleserial-sha3-CWLITEARM.hex")
    time.sleep(1)
    self.scope.io.target_pwr = False
    self.scope.dis()
    self.scope = cw.scope()
    self.scope.default_setup()
    if FCPU!=0:
      self.scope.clock.clkgen_freq = FCPU
      print(self.scope.clock.clkgen_mul, self.scope.clock.clkgen_div)
    time.sleep(1)
    self.scope.clock.freq_ctr_src = 'clkgen'
    time.sleep(1)
    print(self.scope.clock.freq_ctr)
    self.scope.io.target_pwr = True
    self.target = cw.target(self.scope)
    self.scope.io.target_pwr = False
    time.sleep(0.5)
    self.scope.io.target_pwr = True
    time.sleep(0.1)
    print("HELLO?", self.target.read().strip('\n'))
    return

  def test1(self, p, d):
    d_it = d>>3
    d_tail = d%8
    P_size = int(len(p)/2)
    #print(P_size)
    size_tag = hex(P_size%256)[2:].zfill(2)+hex(P_size>>8)[2:].zfill(2)
    #print(size_tag)
    d_tag = hex(d%256)[2:].zfill(2)+hex(d>>8)[2:].zfill(2)
    self.target.write(("x05"+size_tag+d_tag+"\n"))
    time.sleep(0.1)
    discard = self.target.read()
    print(discard[0:8])
    print("Input :", p)
    N_input = int(P_size/8)
    for p_frag in range(0, (N_input+1)):
      if p_frag==N_input:
        frag = "i"+(p[(p_frag*16):].ljust(16, '0'))+"\n"
      else:
        frag = "i"+p[(p_frag*16):(p_frag*16+16)]+"\n"
      #print("Set plaintext "+frag)     
      self.target.write(frag)
      time.sleep(0.1)
      discard = self.target.read()
      #print(discard)
    self.target.write("k\n")
    print("Executing Keccak")
    time.sleep(1.0)
    discard = (self.target.read())
    cipher = ""
    for c_frag in range(0, d_it+1):
      self.target.write("o\n")
      #print("Find out cipher part "+str(c_frag))
      time.sleep(0.1)
      cccc = self.target.read()
      #print(cccc)
      if c_frag==d_it:
        cipher += cccc[1:(2*d_tail+1)]
      else:
        cipher += cccc[1:17]
    print("Output:", cipher)
    self.log.append(cipher)
    return cipher.lower()

  def log_print(self):
    for t in self.log:
      print(t)
    return

  def close(self):
    self.scope.io.target_pwr = False
    time.sleep(2)
    self.scope.io.target_pwr = True
    self.target.dis()
    self.scope.dis()
    return

if __name__=='__main__':
  FC = 5000000
  Temp = Test(FC)
  print("=====================================================================================")
  plain = "11"
  B = 32
  cipher = "270d96d2d552deea64fd2e5b48da6067c3c4523cc5117d6c36f105c1efa226c1"
  own = KECCAK.SHAKE128(plain, B)
  print(cipher == own)
  print(cipher == Temp.test1(plain, B))
  print("=====================================================================================")
  plain = "00"
  B = 16
  cipher = "0b784469a0628e03861cd8a196dfafa0"
  own = KECCAK.SHAKE128(plain, B)
  print(cipher == own)
  print(cipher == Temp.test1(plain, B))
  print("=====================================================================================")
  plain = "00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff00112233445566"
  B = 36
  cipher = "5b4a7824e2c2d2caa958d352dc4077522e66acbd18b9da8beed616e0458e0577253bb207"
  own = KECCAK.SHAKE128(plain, B)
  print(cipher == own)
  print(cipher == Temp.test1(plain, B))
  print("=====================================================================================")
  plain = "00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff0011223344556677"
  B = 81
  cipher = "c079a50a2233cc888a559ce2b71a188c280ebade7e3016caec1f710892226354a7f478e8f6d17709a0405af4a54e3a2fd2b1473ed738155907ff6f3973c12df77ecbb9a974bfc8974e80ce02d1c2b280d3"
  own = KECCAK.SHAKE128(plain, B)
  print(cipher == own)
  print(cipher == Temp.test1(plain, B))
  print("=====================================================================================")
  plain = "2580d82d0d1a4868e89f706d48aa6013137fc502e8dd3c8987c2ed333146dde0f5bec88672a3484ea6678d5c6530703c152b386071fb5cbd6ad6ef4a051730fc431e21cd1dd3eb054e3562e5ea827c6786cddf2707ff77de73c3834a3dbaa3794cb333cb5b53b3428dc5a2773697cf4510bb59627f2f26676cf337e06aeef7ef4b4594d042fbf010f6da257266c8b97b240bb9505d2c8a01b618cb3a824d08643bef7a9288c679fe8eb781185007bc569859bceb84496833eaaa5a3894e67a421968ab6643f055feed003c301274898748df4439081d2135dda1f04ce1cfaba6e3d5045de23e9617780cb524be1a5a29c83e4ceca91ee7ad1c18f282d5350524dccf79012044f1aa347306e9c54ffe2055b283161e3eda536609d209efe4971b29ffdd54a546bd1e19d0ade50128c57d0345af1127120c2824739e58d4352f24b1832cc8eb917a4b3ea6978fe27b143517797f57c39b80925f19894b0e97aa4ffad5124cb0ab236ca1865ce16e43421c06d021ae5ad49f8b8fa975fe9884cc8bbcc6c9ccb8873daca8547d524a2ca4a28151c3d4c24fa1647df1d264f9db81775d4636b1fd71e397b5c304d54f61640cabcb5d577fe2dc61ea804f0978db0ad4746e73e8fa4dd1541ad63a4540add493007f8ef44f1a4e6d25001a895ada9a7ee042ff1c2a2415f95d64600117997731c07b0825"
  B = 331
  cipher = "a23d07607bc28c5ab7bcbb9f042e8e89d86ea4341fedd41a4306622f6e42e0ba0574a251dfa2bf2e8e798533d3338f082764d52d433f51e53709f49c0ab3193b81bdd9f7799281f57c1bd6013dbfbb75740af3a48609d93328330170029e48e94324c1c15b2ce741477a744064d79d4c7823bed5116115ba4e9cad3ca388c7301ae2a3389f3c0f7c0e54c5f74f64763b081dde2c9df18d9279ef3e65b29a853f86e013283fe216e5c0ed24e5610db0dc95f4117c3808f8dba5c0f56c06bb6dd03592f00818636c42b5bc0c8493e2ad0d98d6a09cdda1f8176045597af9c3c91abc65bff2b0443f7f239efb9fdf740185567df7190dc5397ddaead78f48b628cb43903a39ae3b3c16699b30bcbf9a6b35771025f2c69453a2975fec9b640322faef04183f189f7e8f78a3b43805f1410c07755de18dce6d74d7a6627dd9b8398e582e777b532b7cc05a0459"
  own = KECCAK.SHAKE128(plain, B)
  print(cipher == own)
  print(cipher == Temp.test1(plain, B))
  #Temp.log_print()
  Temp.close()

