import os

def generate_style():
    style_string = """.Table
                    {
                        display: table;
                        overflow-x: scroll;
                        white-space: nowrap;
                        resize:both;
                    }
                    .Title
                    {
                        display: table-caption;
                        text-align: center;
                        font-weight: bold;
                        font-size: larger;
                        text-align: center;
                    }
                    .Heading
                    {
                        display: table-row;
                        font-weight: bold;
                        text-align: center;
                    }
                    .Row
                    {
                        display: table-row;
                        text-align: center;
                    }
                    .Cell
                    {
                        display: table-cell;
                        border: solid;
                        border-width: thin;
                        padding-left: 5px;
                        padding-right: 5px;
                        text-align: center;
                        vertical-align: middle;
                    }
                    img {
                        max-width:550px;
                        max-height:550px;
                        width: auto;
                        height: auto;
                        overflow: hidden;
                    }"""

    return style_string



def generate_on_mouse_events(gt_dir,gt_extension,sr_results_dir,img_ext):
    string_command = """ $('img').on({{
                        'mousedown': function(event) {{
                            switch (event.which) {{
                                case 1:

                                    var parent_id = $(this).parent().attr("id")
                                    var para = $(this).parent().parent().children()[0];
                                    var image_number = $(this).parent().parent().parent().attr("id");



                                    console.log(image_number)
                                    var image = $(this).attr('src')
                                    if (parent_id == void 0){{
                                        parent_id = 'Ground Truth'
                                    }}
                                    
                                    if (parent_id!='Ground Truth' && parent_id != 'Bicubic' && !image.includes('PSNR') &&!image.includes('LOss')  &&  !image.includes('NIMA')){{
                                        console.log(parent_id)
                                    var slash_index = image.indexOf(parent_id+"/");
                                    var image_value_string = image.substring(slash_index+(parent_id+"/").length,image.length);
                                    var img_ext = image_value_string.substring(image_value_string.length-3,image_value_string.length);
                                    
                                    if (slash_index == -1){{
                                        var slash_index = image.indexOf("{}");
                                        var image_value_string = image.substring(slash_index+("{}").length,image.length)
                                    }}
                                    else{{
                                        para.innerText = 'Ground Truth Image Shown'
                                    }}
                                    
                                    if (img_ext == 'jpg' || img_ext == 'png'){{
                                        para.innerText = 'Current Loss Shown: ' + parent_id
                                    }}
                                    var src =  "{}" +  image_number + '.'+"{}"
                                     $(this).attr('src', src);
                                     console.log(src)
                                 }}
                        }}
                        }}
                    }});

                    $('img').on({{
                        'mouseup': function(event) {{
                            switch (event.which) {{
                                case 1:
                                var parent_id = $(this).parent().attr("id")
                                var para = $(this).parent().parent().children()[0];
                                var image_number = $(this).parent().parent().parent().attr("id");
                                var image = $(this).attr('src')
                                if (parent_id == void 0){{
                                    parent_id = 'Ground Truth'
                                }}
                                
                                if (parent_id!='Ground Truth' && parent_id != 'Bicubic' && !image.includes('PSNR') &&!image.includes('LOss')  &&  !image.includes('NIMA')){{
                                
                                var slash_index = image.indexOf(parent_id+"/");
                                var image_value_string = image.substring(slash_index+(parent_id+"/").length,image.length);

                                var img_ext = image_value_string.substring(image_value_string.length-3,image_value_string.length);
                                console.log(image_value_string)
                                if (slash_index == -1){{
                                    
                                    var slash_index = image.indexOf("{}");
                                    var image_value_string = image.substring(slash_index+("{}").length,image.length)
                                }}
                                else{{
                                    para.innerText = 'Ground Truth Image Shown'
                                }}
                               
                                if (img_ext == 'jpg' || img_ext == 'png'){{
                                    para.innerText = 'Current Loss Shown: ' + parent_id
                                }}
                                var src = "{}" +parent_id+'/'+image_number+'/'+image_number+'_SR.'+"{}";
                                 $(this).attr('src', src);
                                 
                             }}
                        }}
                        }}
                    }});""".format(os.path.join(gt_dir,""),
                                   os.path.join(gt_dir,""),
                                   os.path.join(gt_dir,""),
                                   gt_extension,os.path.join(gt_dir,""),
                                   os.path.join(gt_dir,""),
                                   os.path.join(sr_results_dir,""),
                                   img_ext)

    return string_command
