/**
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *	Copyright 2011 Andrew Rice (acr31@cam.ac.uk)
 */
package uk.ac.cam.acr31.geomessagingserver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;

/**
 * Servlet implementation class PostMessageServlet
 */
public class PostMessageServlet extends DatabaseServlet {
	private static final long serialVersionUID = 1L;

	/**
	 * @see HttpServlet#HttpServlet()
	 */
	public PostMessageServlet() {
		super();
	}

	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		XMLWriter w = new XMLWriter(resp.getWriter());
		w.open("html").open("body").open("form", "enctype",
				"multipart/form-data", "method", "post");
		w.open("p").text("Message ").open("textarea", "name",
				DatabaseServlet.REQ_MESSAGE).close("p");
		w.open("p").text("Picture ").open("input", "name",
				DatabaseServlet.REQ_PICTURE, "type", "file").close("p");
		w.open("p").text("Latitude ").open("input", "name",
				DatabaseServlet.REQ_LATITUDE, "type", "text").close("p");
		w.open("p").text("Longitude ").open("input", "name",
				DatabaseServlet.REQ_LONGITUDE, "type", "text").close("p");
		w.open("p").open("input", "type", "submit").close("p");
		w.close("html");
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		String message = null;
		Float latitude = null;
		Float longitude = null;
		File imageFile = null;
		response.setContentType("text/plain");
		boolean isMultipart = ServletFileUpload.isMultipartContent(request);
		if (isMultipart) {
			try {
				ServletFileUpload upload = new ServletFileUpload();
				FileItemIterator step = upload.getItemIterator(request);
				while (step.hasNext()) {
					FileItemStream item = step.next();
					if (item.isFormField()) {
						if (item.getFieldName().equals(
								DatabaseServlet.REQ_LATITUDE)) {
							latitude = Util.parseFloat(Streams.asString(item
									.openStream()));
						} else if (item.getFieldName().equals(
								DatabaseServlet.REQ_LONGITUDE)) {
							longitude = Util.parseFloat(Streams.asString(item
									.openStream()));
						} else if (item.getFieldName().equals(
								DatabaseServlet.REQ_MESSAGE)) {
							message = new String(Streams.asString(item
									.openStream()));
						}
					} else if (item.getFieldName().equals(
							DatabaseServlet.REQ_PICTURE)) {
						InputStream is = item.openStream();
						imageFile = File.createTempFile("image", ".jpg",
								new File(mImageRepository));
						FileOutputStream fs = new FileOutputStream(imageFile);
						byte[] buf = new byte[1024];
						int read;
						while ((read = is.read(buf)) != -1) {
							fs.write(buf, 0, read);
						}
						fs.close();
					}
				}
				if (message != null && latitude != null && longitude != null) {
					Connection db = mDataSource.getConnection();
					try {
						db.setAutoCommit(true);
						PreparedStatement ps = db
								.prepareStatement("INSERT INTO messages(uploadtime,message,latitude,longitude,picturename) VALUES (?,?,?,?,?)");
						try {
							ps.setLong(1, new Date().getTime());
							ps.setString(2, message);
							ps.setFloat(3, latitude);
							ps.setFloat(4, longitude);
							ps.setString(5, imageFile != null ? imageFile
									.getName() : "unknown.jpg");
							ps.executeUpdate();
							imageFile = null;
						} finally {
							ps.close();
						}
					} finally {
						db.close();
					}
					response.getWriter().print("OK");
					return;
				} else {
					response.getWriter().print(
							"Missing: " + message + " " + latitude + " "
									+ longitude + " " + imageFile);
					return;
				}
			} catch (FileUploadException e) {
				response.getWriter().print(e);
				return;
			} catch (SQLException e) {
				response.getWriter().print(e);
				return;
			} finally {
				if (imageFile != null)
					imageFile.delete();
			}
		} else {
			response.getWriter().print("Not a multipart upload");
			return;
		}
	}
}
