/**
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *	Copyright 2011 Andrew Rice (acr31@cam.ac.uk)
 */

package uk.ac.cam.acr31.geomessagingserver;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.sql.DataSource;

public abstract class DatabaseServlet extends HttpServlet {

	private static final long serialVersionUID = 1L;
	protected DataSource mDataSource;
	protected String mImageRepository;
	protected String mUrlPrefix;
	
	
	public static final String REQ_MESSAGE = "message";
	public static final String REQ_PICTURE = "picture";
	public static final String REQ_LATITUDE = "latitude";
	public static final String REQ_LONGITUDE = "longitude";
	public static final String REQ_DISTANCE = "distance";

	public DatabaseServlet() {
		super();
	}

	@Override
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
	
		ServletContext context = getServletContext();
		mImageRepository = context.getInitParameter("imageRepository");
		if (mImageRepository == null) {
			throw new ServletException("Failed to find context parameter imageRepository");
		}
	
		mUrlPrefix = context.getInitParameter("urlPrefix");
		if (mUrlPrefix == null) {
			throw new ServletException("Failed to find context parameter urlPrefix");
		}
			
		try {
			Context ctx = new InitialContext();
			mDataSource = (DataSource) ctx
					.lookup("java:comp/env/jdbc/generaldb");
		} catch (NamingException e) {
			throw new ServletException(e);
		}
	
		try {
			Connection db = mDataSource.getConnection();
			testCreate(
					"SELECT uploadtime, message,latitude,longitude,picturename from messages",
					"create table messages (uploadtime int not null, message text not null, latitude float not null, longitude float not null, picturename varchar(1024) not null)",
					db);
			db.close();
		} catch (SQLException e) {
			throw new ServletException("Failed to initialise database", e);
		}
	}

	private void testCreate(String test, String create, Connection db)
			throws SQLException {
				Statement s = db.createStatement();
				try {
					s.executeQuery(test);
				} catch (SQLException e) {
					s.execute(create);
				}
			}

}