/**
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *	Copyright 2011 Andrew Rice (acr31@cam.ac.uk)
 */
package uk.ac.cam.acr31.geomessagingserver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

public abstract class MessageCollector {
	private Float longitude;
	private Float latitude;
	private float miles;

	public MessageCollector(Float latitude, Float longitude, float miles) {
		super();
		this.latitude = latitude;
		this.longitude = longitude;

		this.miles = miles;
	}

	protected abstract void handleRow(String message, float latitude,
			float longitude, String pictureName,Date uploadTime);

	public void doQuery(Connection db) throws SQLException {
		PreparedStatement ps = null;
		try {
			if (latitude != null && longitude != null) {
				ps = db
						.prepareStatement("SELECT message,latitude,longitude,picturename,uploadtime "
								+ "FROM messages WHERE "
								+ "(latitude - ?)*(latitude-?)+(longitude-?)*(longitude-?) < ? ORDER BY uploadtime desc limit 20");
				ps.setFloat(1, latitude);
				ps.setFloat(2, latitude);
				ps.setFloat(3, longitude);
				ps.setFloat(4, longitude);
				ps.setFloat(5, miles * miles);
			} else {
				ps = db
						.prepareStatement("SELECT message,latitude,longitude,picturename,uploadtime "
								+ "FROM messages order by uploadtime desc limit 20");
			}
			ResultSet rs = ps.executeQuery();
			try {
				while (rs.next()) {
					handleRow(rs.getString(1), rs.getFloat(2), rs.getFloat(3),
							rs.getString(4),new Date(rs.getLong(5)));
				}
			} finally {
				rs.close();
			}

		} finally {
			if (ps != null)
				ps.close();
		}
	}
}
