/**
 * Copyright 2010 Andrew Rice
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package uk.ac.cam.acr31.oggdecoder;

import java.io.IOException;
import java.io.InputStream;

import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class HttpOggStream extends OggStream {

	private long currentPosition;
	private InputStream inputStream;
	private HttpClient client = new DefaultHttpClient();
	private HttpUriRequest request;

	public HttpOggStream(String address) throws InvalidStreamException {
		try {
			request = new HttpGet(address);
			HttpResponse response = client.execute(request);
			if (response.getStatusLine().getStatusCode() != 200) {
				throw new InvalidStreamException("Failed to establish stream: "
						+ response.getStatusLine().toString());
			}
			inputStream = response.getEntity().getContent();
		} catch (ClientProtocolException e) {
			throw new InvalidStreamException(e);
		} catch (IllegalStateException e) {
			throw new InvalidStreamException(e);
		} catch (IOException e) {
			throw new InvalidStreamException(e);
		}
		currentPosition = 0;
	}

	@Override
	public void read(byte[] buf, int off, int len) throws EndOfStreamException,
			InvalidStreamException {
		int count = len;
		while (len > 0) {
			int read;
			try {
				read = inputStream.read(buf, off, len);
			} catch (IOException e) {
				throw new InvalidStreamException(e);
			}
			if (read == -1) {
				throw new EndOfStreamException(
						"Reached end of stream attempting to read " + count
								+ " bytes");
			}
			off += read;
			len -= read;
		}
		currentPosition += count;
	}

	@Override
	public void close() {
		try {
			request.abort();
			inputStream.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
