/**
 * Copyright 2010 Andrew Rice
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package uk.ac.cam.acr31.oggdecoder;

public class OggLogicalStream {

	private boolean ended;
	private int bitstreamSerialNumber;
	private OggPacketReceiver packetReceiver;

	public OggLogicalStream(int bitStreamSerialNumber) {
		this.ended = false;
		this.bitstreamSerialNumber = bitStreamSerialNumber;
	}

	public void setPacketReceiver(OggPacketReceiver packetReceiver) {
		this.packetReceiver = packetReceiver;
	}

	private boolean packetEnded = true;

	public void writeSegment(long granulePosition, OggStream source, int length,boolean endPacket)
			throws EndOfStreamException, InvalidStreamException {
		boolean startPacket = packetEnded;
//		boolean endPacket = length != 255;
		packetReceiver.packetData(granulePosition, source, length, startPacket,
				endPacket);
		packetEnded = endPacket;
	}

	public boolean needsData() {
		return packetReceiver.needsData();
	}

	public int getBitstreamSerialNumber() {
		return bitstreamSerialNumber;
	}

	public boolean isEnded() {
		return ended;
	}

	public void endOfStream() {
		this.ended = true;
	}
}
