/**
 * Copyright 2010 Andrew Rice
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package uk.ac.cam.acr31.oggdecoder;

public interface OggPacketReceiverFactory {

	/**
	 * Return true if this type of PacketReciever can process data for this LogicalStream
	 * 
	 * @param data - the bytes of the first Packet in the stream
	 * @return
	 */
	public boolean testFirstPacket(byte[] data);
	
	/**
	 * Return a new instance of a PacketReceiver for this stream
	 * @return
	 */
	public OggPacketReceiver getInstance();
	
}
