/*
#define MAX_NUM_NEIGHBORS_RELAXATION 1000
#define LINE_LENGTH 1000

#include "fileIO.h"
#include "relaxation.h"
#include "subsample.h"
#include <string.h>
#include <time.h>

int main(int argc, char *argv[])
{
	char* inFileName = "files.txt";
	double sigmaN = 1;
	double th = 0.5;
	bool sharpFeatures = 1;

	int maxIteration = 10;
	int dim = 3;


	//Convert
	
	//int numPoints;
	//double* points = new double[3*187136];
	//double* normals = new double[3*187136];
	//numPoints = readObj(inFileName, points, normals);
	//writeApts(outFileName, points, normals, numPoints);
	//delete[] points;
	//delete[] normals;
	//exit(0);
	

	
	//convert_noff_apts(inFileName, outFileName);
	//exit(0);
	

	
	//scaleApts(inFileName);
	//exit(0);
	

	char outFileNameSubsampling[LINE_LENGTH];
	char outFileNameResampling[LINE_LENGTH];
	char lineFromFile[LINE_LENGTH];
	char charTemp[1];
	FILE* filePointer = fopen (inFileName, "r");
	int numberOfModels;
	fgets(lineFromFile, LINE_LENGTH, filePointer);
	sscanf (lineFromFile,"%d",&numberOfModels);
	
	int numSigmas = 20;
	double* sigmas = new double[numSigmas];
	for (int sigmaIndex = 0; sigmaIndex < numSigmas; sigmaIndex++)
		sigmas[sigmaIndex] = (sigmaIndex+1)*0.2;

	double* subsamplingTimings = new double[numberOfModels*numSigmas];
	double* resamplingTimings = new double[numberOfModels*numSigmas];
	//int* numPtsInputSubsampling = new int[numberOfModels*numSigmas];
	int* numPtsOutputSubsampling = new int[numberOfModels*numSigmas];

	clock_t start;
	for (int modelIndex = 0; modelIndex < numberOfModels; modelIndex++)
	{
		//Get the filename of the model
		fgets(lineFromFile, LINE_LENGTH, filePointer);
		for (int i = 0; i < LINE_LENGTH; i++)
		{
			charTemp[0] = lineFromFile[i];
			if (charTemp[0] == 10)
			{
				lineFromFile[i] = '\0';
				break;
			}
		}
		
		//Random Shuffling
		//randomlyShufflePointsApts(lineFromFile, lineFromFile);

		for (int sigmaIndex = 0; sigmaIndex < numSigmas; sigmaIndex++)
		{
			sprintf(outFileNameSubsampling, "%s_%2.2f_subsampling.apts", lineFromFile, sigmas[sigmaIndex]);
			//Subsample
			//-------------------------------------------------------------------------------------------
			int numSampledPoints[1];
			start = clock();
			double* pointsNormals = subsample(lineFromFile, sigmas[sigmaIndex], sigmaN, th, numSampledPoints);
			subsamplingTimings[modelIndex*numSigmas + sigmaIndex] = static_cast<double>(clock()-start)/CLOCKS_PER_SEC;
			numPtsOutputSubsampling[modelIndex*numSigmas + sigmaIndex] = numSampledPoints[0];
			printf("Subsampling Done");
			//char* outFileNameSubsampling = "";
			//strcat(outFileNameSubsampling, outFileName);
			//strcat(outFileNameSubsampling, "_simplified.apts");
			writeApts(outFileNameSubsampling, pointsNormals, numSampledPoints[0]);
			writeXYZ("test.txt", pointsNormals, numSampledPoints[0], 2*dim);
			delete[] pointsNormals;
			//-------------------------------------------------------------------------------------------

			//sprintf(outFileNameResampling, "%s_%2.2f_resampling.apts", lineFromFile, sigmas[sigmaIndex]);
			sprintf(outFileNameResampling, "temp.apts");
			//Resample
			//-------------------------------------------------------------------------------------------
			int numPoints;
			double* pointsAndNormals[2];
			numPoints = readApts(outFileNameSubsampling, pointsAndNormals);
			double* points = pointsAndNormals[0];
			double* normals = pointsAndNormals[1];
			start = clock();
			relaxPoints(points, normals, numPoints, dim, sigmas[sigmaIndex], sigmaN, MAX_NUM_NEIGHBORS_RELAXATION, maxIteration, sharpFeatures);
			resamplingTimings[modelIndex*numSigmas + sigmaIndex] = static_cast<double>(clock()-start)/CLOCKS_PER_SEC;
			printf("Resampling Done");
			writeApts(outFileNameResampling, points, normals, numPoints);
			writeXYZ(strcat(outFileNameResampling,".txt"), points, numPoints, dim);
			delete[] points;
			delete[] normals;
			//-------------------------------------------------------------------------------------------
		}
	}

	//Print timings
	for (int modelIndex = 0; modelIndex < numberOfModels; modelIndex++)
		for (int sigmaIndex = 0; sigmaIndex < numSigmas; sigmaIndex++)
			printf("%f\n", subsamplingTimings[modelIndex*numSigmas + sigmaIndex]);

	printf("\n\n");

	for (int modelIndex = 0; modelIndex < numberOfModels; modelIndex++)
		for (int sigmaIndex = 0; sigmaIndex < numSigmas; sigmaIndex++)
			printf("%f\n", resamplingTimings[modelIndex*numSigmas + sigmaIndex]);

	printf("\n\n");

	for (int modelIndex = 0; modelIndex < numberOfModels; modelIndex++)
		for (int sigmaIndex = 0; sigmaIndex < numSigmas; sigmaIndex++)
			printf("%d\n", numPtsOutputSubsampling[modelIndex*numSigmas + sigmaIndex]);
}
*/