#include "inverseIterative.h"
#include "dynamicKdTree.h"
#include "sorting.h" 

#include <stdio.h>
#include <conio.h>
#include <cstdlib>   
#include <time.h>   

#define MAX_NUM_NEIGHBORS 10000
#define LINE_LENGTH 200
#define MAX_OUTPUT_NUM 5000000
#define DIM 3

void generateRandomPermutation(int* numbers, int num)
{
	srand ( time(NULL) );
	int i, temp, m = num;
	while (m > 0)
	{
		i = (int)((double)rand() / RAND_MAX * m) + 1;
		temp = numbers[i];
		numbers[i] = numbers[m];
		numbers[m] = temp;
		m--;
	}
}

void randomlyShuffleVerticesOFF(char* fileName, char* outFileName)
{
	//Chop file into pieces
	int num;
	char line [LINE_LENGTH];
	char writeFileName [LINE_LENGTH];
	FILE* filePointer = fopen (fileName, "r");
	fgets(line, LINE_LENGTH, filePointer);
	fgets(line, LINE_LENGTH, filePointer);
	sscanf (line,"%d%*d%*d",&num);

	int lineCounter = 0;
	int numFiles = 100;
	int fileCounter = 0;
	int randomFileIndex;

	FILE** writeFilePointer = new FILE*[numFiles];
	for (int i = 0; i < numFiles; i++)
	{
		sprintf(writeFileName, "file%d.temp",i);
		writeFilePointer[i] = fopen(writeFileName, "w");
	}

	while(fgets(line, LINE_LENGTH, filePointer))
	{
		randomFileIndex = (int)((double)rand() / RAND_MAX * numFiles);
		if (randomFileIndex > numFiles - 1)
			randomFileIndex = numFiles - 1;
		fprintf(writeFilePointer[randomFileIndex],"%s",line);
	}
	fclose(filePointer);

	printf("Write done");

	for (int i = 0; i < numFiles; i++)
		fclose(writeFilePointer[i]);

	filePointer = fopen (outFileName, "w");
	for (int i = 0; i < numFiles; i++)
	{
		sprintf(writeFileName, "file%d.temp",i);
		writeFilePointer[i] = fopen(writeFileName, "r");
	}

	fprintf(filePointer, "OFF\n%d\n", num);
	for (int i = 0; i < numFiles; i++)
	{
		while(fgets(line, LINE_LENGTH, writeFilePointer[i] ))
		{
			fprintf(filePointer,"%s",line);
		}
	}

	fclose(filePointer);

	for (int i = 0; i < numFiles; i++)
		fclose(writeFilePointer[i]);

	for (int i = 0; i < numFiles; i++)
	{
		sprintf(writeFileName, "file%d.temp",i);
		remove(writeFileName);
	}
}

void randomlyShufflePointsApts(char* fileName, char* outFileName)
{
	//Chop file into pieces
	int num;
	char line [LINE_LENGTH];
	char writeFileName [LINE_LENGTH];
	FILE* filePointer = fopen (fileName, "r");
    for (unsigned int i = 0; i < 6; ++i)
        fgets(line, LINE_LENGTH, filePointer);
    sscanf (line,"%*s %d",&num);
    fgets(line, LINE_LENGTH, filePointer);

	int lineCounter = 0;
	int numFiles = 100;
	int fileCounter = 0;
	int randomFileIndex;

	FILE** writeFilePointer = new FILE*[numFiles];
	for (int i = 0; i < numFiles; i++)
	{
		sprintf(writeFileName, "file%d.temp",i);
		writeFilePointer[i] = fopen(writeFileName, "w");
	}

	while(fgets(line, LINE_LENGTH, filePointer))
	{
		randomFileIndex = (int)((double)rand() / RAND_MAX * numFiles);
		if (randomFileIndex > numFiles - 1)
			randomFileIndex = numFiles - 1;
		fprintf(writeFilePointer[randomFileIndex],"%s",line);
	}
	fclose(filePointer);

	printf("Write done");

	for (int i = 0; i < numFiles; i++)
		fclose(writeFilePointer[i]);

	filePointer = fopen (outFileName, "w");
	for (int i = 0; i < numFiles; i++)
	{
		sprintf(writeFileName, "file%d.temp",i);
		writeFilePointer[i] = fopen(writeFileName, "r");
	}

	fprintf(filePointer, "[Expe/PointSet/Ascii/0.2]\n");
    fprintf(filePointer, "property position 3 r32\n");
    fprintf(filePointer, "property radius 1 r32\n");
    fprintf(filePointer, "property normal 3 r32\n");
    fprintf(filePointer, "property color 4 ui8\n");
    fprintf(filePointer, "nofpoints      %d\n", num);
    fprintf(filePointer, "data\n");
	for (int i = 0; i < numFiles; i++)
	{
		while(fgets(line, LINE_LENGTH, writeFilePointer[i] ))
		{
			fprintf(filePointer,"%s",line);
		}
	}

	fclose(filePointer);

	for (int i = 0; i < numFiles; i++)
		fclose(writeFilePointer[i]);

	for (int i = 0; i < numFiles; i++)
	{
		sprintf(writeFileName, "file%d.temp",i);
		remove(writeFileName);
	}
}


double* subsample(char* fileName, double sigmaP, double sigmaN, double th, int* numSampledPoints)
{

    printf("\n");

    int kdTreeTime = 0;
    int ioTime = 0;
	int startTime;
    int currentTime;
    
    unsigned int num;
    unsigned int dim = DIM;
    //printf("here");
    double* sampledPointsNormals = new double[MAX_OUTPUT_NUM*2*DIM]; 
	
    FILE* filePointer = fopen (fileName, "r");
    
    char line [LINE_LENGTH];
    
    //Get num
	/*
	fgets(line, LINE_LENGTH, filePointer);
	fgets(line, LINE_LENGTH, filePointer);
	sscanf (line,"%d%*d%*d",&num);
	printf("\n%d\n", num);
	*/

	
    //for (unsigned int i = 0; i < 6; ++i)
    //    fgets(line, LINE_LENGTH, filePointer);
	fgets(line, LINE_LENGTH, filePointer);
    sscanf (line,"%d",&num);
    
	

    
    
    double gaussianStd = 2.5;
    unsigned int currentNumSampledPoints = 0;
    unsigned int numIterations = 1;

    int* indicesData = new int[num]; 
    int* neighborIndices = new int[MAX_NUM_NEIGHBORS];
	double* neighborDistances = new double[MAX_NUM_NEIGHBORS];

    unsigned int ii = 0;
    int currentPointIndex;
    kdtree * kdTree = kd_create( dim );
    int neighborIndex;
    unsigned int numNeighborIndices;
    struct kdres * neighborIndicesDataRaw;
    double* x = new double[2*dim];
    double* p = new double[dim];
    double* n = new double[dim];
    int percentage = 0;
    int oldPercentage = 0;
    double* neighborPoint = new double[dim];
    double reconstructionError = 0;
    
	startTime = clock();
    while (ii < num - 1 && currentNumSampledPoints < MAX_OUTPUT_NUM)
    {
        ii++;
        currentPointIndex = currentNumSampledPoints;
        
        currentTime = clock();
        fgets(line, LINE_LENGTH, filePointer);
        sscanf (line,"%lf %lf %lf %lf %lf %lf", &p[0], &p[1], &p[2], &n[0], &n[1], &n[2]);
		//sscanf (line,"%lf %lf %lf %lf %lf %lf", &p[0], &p[1], &p[2], &n[0], &n[1], &n[2]);
        ioTime = ioTime + (clock() - currentTime);

        p[0] = p[0] / sigmaP;
        p[1] = p[1] / sigmaP;
        p[2] = p[2] / sigmaP;
        
        x[0] = p[0]; x[1] = p[1]; x[2] = p[2];
        x[3] = n[0] / sigmaN; x[4] = n[1] / sigmaN; x[5] = n[2] / sigmaN;
        
        currentTime = clock();
        neighborIndicesDataRaw = kd_nearest_range(kdTree, p, gaussianStd);
        
        numNeighborIndices = 0;
        
        while(!kd_res_end(neighborIndicesDataRaw) && numNeighborIndices < MAX_NUM_NEIGHBORS)
        {
            neighborIndex = *(int*)kd_res_item(neighborIndicesDataRaw, neighborPoint);
            neighborIndices[numNeighborIndices] = neighborIndex;
			neighborDistances[numNeighborIndices] = sqDistVect(p, neighborPoint, dim);
            numNeighborIndices++;
            kd_res_next(neighborIndicesDataRaw);
        }
		kd_res_free( neighborIndicesDataRaw );
        kdTreeTime = kdTreeTime + (clock() - currentTime);

		//Sort distances
		//for (int i = 0; i < numNeighborIndices; i++)
		//	printf("%lf %d\n", neighborDistances[i], neighborIndices[i]);
		//printf("\n.............................\n");
		Sorting::sortKeyValuePairs(neighborIndices, neighborDistances, numNeighborIndices);
		//for (int i = 0; i < numNeighborIndices; i++)
		//	printf("%lf %d\n", neighborDistances[i], neighborIndices[i]);
		//printf("\n\n");

        if (numNeighborIndices > 0)
        {
            //reconstructionError = 1 - takeInverseIterative(x, 1, pointsNormals, neighborIndices, numNeighborIndices, dim, th);
            reconstructionError = 1 - takeInverseIterative(x, sampledPointsNormals, neighborIndices, numNeighborIndices, dim, th);
            //reconstructionError = 1;
            //printf("%d, %d\n",dim,num);
        }
        else
            reconstructionError = 1;

        
        if (reconstructionError > th)        
        {
            indicesData[currentNumSampledPoints] = currentNumSampledPoints;
            
            currentTime = clock();
            kd_insert( kdTree, p, &indicesData[currentNumSampledPoints] );
            kdTreeTime = kdTreeTime + (clock() - currentTime);
            
            sampledPointsNormals[currentNumSampledPoints*2*DIM + 0] = x[0];
            sampledPointsNormals[currentNumSampledPoints*2*DIM + 1] = x[1];
            sampledPointsNormals[currentNumSampledPoints*2*DIM + 2] = x[2];
            
            sampledPointsNormals[currentNumSampledPoints*2*DIM + 3] = x[3];
            sampledPointsNormals[currentNumSampledPoints*2*DIM + 4] = x[4];
            sampledPointsNormals[currentNumSampledPoints*2*DIM + 5] = x[5];
                        
            currentNumSampledPoints++;
        }
        

        percentage = (int)(((double)ii / num) * 100);
        if (percentage > oldPercentage)
        {
            //printf("%d\n",currentNumSampledPoints);
            printf("\r%d",percentage);
			oldPercentage = percentage;
        }
    
    }
    
    if (currentNumSampledPoints == MAX_OUTPUT_NUM)
		printf("Insufficient array size");

    kd_free( kdTree );
	delete[] indicesData;//_freea(indicesData);
	delete[] neighborIndices;//_freea(neighborIndices);
	delete[] neighborDistances;
	delete[] x;
    delete[] p;
    delete[] n;
    delete[] neighborPoint;
    fclose(filePointer);
     
    *numSampledPoints = currentNumSampledPoints;
    
    printf("\nKdTreeTime: %d\n", (int)((kdTreeTime)*1E3/CLOCKS_PER_SEC));
    printf("IO Time: %d\n", (int)((ioTime)*1E3/CLOCKS_PER_SEC));
    printf("Total Time: %d\n", (int)((clock()-startTime)*1E3/CLOCKS_PER_SEC));

	for (int i = 0; i < *numSampledPoints; i++)
	{
		sampledPointsNormals[i*6]     *= sigmaP;
		sampledPointsNormals[i*6 + 1] *= sigmaP;
		sampledPointsNormals[i*6 + 2] *= sigmaP;
		sampledPointsNormals[i*6 + 3] *= sigmaN;
		sampledPointsNormals[i*6 + 4] *= sigmaN;
		sampledPointsNormals[i*6 + 5] *= sigmaN;
	}

    return sampledPointsNormals;
}

/*
double* subsample(char* fileName, double sigmaP, double sigmaN, double th, int* numSampledPoints)
{
    printf("\n");


    int kdTreeTime = 0;
    int ioTime = 0;
	int startTime;
    int currentTime;
    
    unsigned int num;
    unsigned int dim = DIM;
            
    double* sampledPointsNormals = new double[MAX_OUTPUT_NUM*2*DIM]; 
    FILE* filePointer = fopen (fileName, "r");
    
    char line [LINE_LENGTH];
    
    //Get num
    for (unsigned int i = 0; i < 6; ++i)
        fgets(line, LINE_LENGTH, filePointer);
    sscanf (line,"%*s %d",&num);
    fgets(line, LINE_LENGTH, filePointer);

	double* points = new double[num*DIM];
	double* normals = new double[num*DIM];
	double* p = new double[dim];
    double* n = new double[dim];
    currentTime = clock();
	for (unsigned int i = 0; i < num; ++i)
	{
        fgets(line, LINE_LENGTH, filePointer);
        sscanf (line,"%lf %lf %lf %*s %*s %*s %lf %lf %lf", &p[0], &p[1], &p[2], &n[0], &n[1], &n[2]);
		points[i*DIM] = p[0];
		points[i*DIM + 1] = p[1];
		points[i*DIM + 2] = p[2];
		normals[i*DIM] = n[0];
		normals[i*DIM + 1] = n[1];
		normals[i*DIM + 2] = n[2];
	}
    ioTime = ioTime + (clock() - currentTime);
    
    double gaussianStd = 2.5;
    unsigned int currentNumSampledPoints = 0;
    unsigned int numIterations = 1;

    int* indicesData = new int[num]; 
    int* neighborIndices = new int[MAX_NUM_NEIGHBORS];
	double* neighborPoints = new double[MAX_NUM_NEIGHBORS*2*dim];

    unsigned int ii, iii = 0;
    int currentPointIndex;
    kdtree * kdTree = kd_create( dim );
    int neighborIndex;
    unsigned int numNeighborIndices;
    struct kdres * neighborIndicesDataRaw;
    double* x = new double[2*dim];
    int percentage = 0;
    int oldPercentage = 0;
    double* neighborPoint = new double[dim];
    double reconstructionError = 0;
    
	
	int* indices = new int[num];
	for (int i = 0; i < num; i++)
		indices[i] = i;
	generateRandomPermutation(indices, num);
	
		
	startTime = clock();
    while (iii < num-1)
    {
		ii = indices[iii];
		iii++;
		
        currentPointIndex = currentNumSampledPoints;
        
		p[0] = points[ii*DIM];
		p[1] = points[ii*DIM + 1];
		p[2] = points[ii*DIM + 2];

		n[0] = normals[ii*DIM];
		n[1] = normals[ii*DIM + 1];
		n[2] = normals[ii*DIM + 2];

        p[0] = p[0] / sigmaP;
        p[1] = p[1] / sigmaP;
        p[2] = p[2] / sigmaP;
        
        x[0] = p[0]; x[1] = p[1]; x[2] = p[2];
        x[3] = n[0] / sigmaN; x[4] = n[1] / sigmaN; x[5] = n[2] / sigmaN;
        
        currentTime = clock();
        neighborIndicesDataRaw = kd_nearest_range(kdTree, p, gaussianStd);
        
        numNeighborIndices = 0;
        
        while(!kd_res_end(neighborIndicesDataRaw))
        {
            neighborIndex = *(int*)kd_res_item(neighborIndicesDataRaw, neighborPoint);
            neighborIndices[numNeighborIndices] = neighborIndex;
			
			neighborIndices[numNeighborIndices] = numNeighborIndices;
			for (int jj = 0; jj < dim*2; jj++)
				neighborPoints[numNeighborIndices*2*dim + jj] = sampledPointsNormals[neighborIndex*dim*2 + jj];

            numNeighborIndices++;
            kd_res_next(neighborIndicesDataRaw);
        }
        kdTreeTime = kdTreeTime + (clock() - currentTime);

        if (numNeighborIndices > 0)
        {
			//reconstructionError = 0;
			//for (unsigned int i = 0; i < numNeighborIndices; i++)
			//	reconstructionError +=  exp(-2*sqDistVM(x, neighborPoints, neighborIndices[i], 2*dim));
			//reconstructionError = 1 - reconstructionError/(double)numNeighborIndices;
			//if (reconstructionError >= th)
            //reconstructionError = 1 - takeInverseIterative(x, 1, pointsNormals, neighborIndices, numNeighborIndices, dim, th);
				//reconstructionError = 1 - takeInverseIterative(x, sampledPointsNormals, neighborIndices, numNeighborIndices, dim, th);
				reconstructionError = 1 - takeInverseIterative(x, neighborPoints, neighborIndices, numNeighborIndices, dim, th);
            //reconstructionError = 1;
            //printf("%d, %d\n",dim,num);
        }
        else
            reconstructionError = 1;

        
        if (reconstructionError > th)        
        {
            indicesData[currentNumSampledPoints] = currentNumSampledPoints;
            
            currentTime = clock();
            kd_insert( kdTree, p, &indicesData[currentNumSampledPoints] );
            kdTreeTime = kdTreeTime + (clock() - currentTime);
            
            sampledPointsNormals[currentNumSampledPoints*2*DIM + 0] = x[0];
            sampledPointsNormals[currentNumSampledPoints*2*DIM + 1] = x[1];
            sampledPointsNormals[currentNumSampledPoints*2*DIM + 2] = x[2];
            
            sampledPointsNormals[currentNumSampledPoints*2*DIM + 3] = x[3];
            sampledPointsNormals[currentNumSampledPoints*2*DIM + 4] = x[4];
            sampledPointsNormals[currentNumSampledPoints*2*DIM + 5] = x[5];
                        
            currentNumSampledPoints++;
        }
        

        percentage = (int)(((double)ii / num) * 100);
        if (percentage > oldPercentage)
        {
            //printf("%d\n",currentNumSampledPoints);
            printf("\r%d",percentage);
			oldPercentage = percentage;
        }
    
    }
    
    
    kd_free( kdTree );
	delete[] indicesData;//_freea(indicesData);
	delete[] neighborIndices;//_freea(neighborIndices);
	delete[] neighborPoints;
	delete[] x;
    delete[] p;
    delete[] n;
    delete[] neighborPoint;
	delete[] points;
	delete[] normals;
	delete[] indices;
    fclose(filePointer);
     
    *numSampledPoints = currentNumSampledPoints;
    
    printf("\nKdTreeTime: %d\n", (int)((kdTreeTime)*1E3/CLOCKS_PER_SEC));
    printf("IO Time: %d\n", (int)((ioTime)*1E3/CLOCKS_PER_SEC));
    printf("Total Time: %d\n", (int)((clock()-startTime)*1E3/CLOCKS_PER_SEC));

	for (int i = 0; i < *numSampledPoints; i++)
	{
		sampledPointsNormals[i*6]     *= sigmaP;
		sampledPointsNormals[i*6 + 1] *= sigmaP;
		sampledPointsNormals[i*6 + 2] *= sigmaP;
		sampledPointsNormals[i*6 + 3] *= sigmaN;
		sampledPointsNormals[i*6 + 4] *= sigmaN;
		sampledPointsNormals[i*6 + 5] *= sigmaN;
	}

    return sampledPointsNormals;
}
*/
