#ifndef _SORTING_H_
#define _SORTING_H_

#include <algorithm>
#include <deque>
using namespace std;

class KeyValuePair
{
public:
	int key;
	double value;
	
	bool operator() (const KeyValuePair& x, const KeyValuePair& y) const
	{
		return (x.value < y.value);
	}

	bool operator() (const KeyValuePair& x, const double& yValue) const
	{
		return (x.value < yValue);
	}
};

class Sorting
{
public:
	static void sortKeyValuePairs(int* keys, double* values, int numPairs)
	{
		deque<KeyValuePair> keyValuePairDeque;
		for (int i = 0; i < numPairs; i++)
		{
			KeyValuePair keyValuePair;
			keyValuePair.key = keys[i];
			keyValuePair.value = values[i];
			keyValuePairDeque.push_back(keyValuePair);
		}

		//Sort
		sort(keyValuePairDeque.begin(), keyValuePairDeque.end(), KeyValuePair());

		for (int i = 0; i < numPairs; i++)
		{
			keys[i] = keyValuePairDeque.at(i).key;
			values[i] = keyValuePairDeque.at(i).value;
		}

	}
};

#endif