#ifndef PROJECT_H
#define PROJECT_H

void copyVector(double* dest, double* source, int dim)
{
	for (int i = 0; i < dim; i++)
		dest[i] = source[i];
}

void fillZeros(double* vector, int dim)
{
	for (int i = 0; i < dim; i++)
		vector[i] = 0;
}

/*
double computeGradient(double* point, double* normalPrev, double* points, double normals, int* neighborIndices, double sigmaP, double sigmaN, int numNeighbors, int dim)
{
	double* a = new double[dim];
	double* b = new double[dim];
	double* n = new double[dim];
	double weight;
	double sum;
	double d;
	double f = 0;
	int index;

	fillZeros(a);
	fillZeros(b);
	fillZeros(n);

	sum = 0;
	for (int i = 0; i < numNeighbors; i ++)
	{
		index = neighborIndices[i];
		weight = exp(-sqDistVM(point, points, index, dim) / sigmaP / sigmaP - sqDistVM(normalPrev, normals, index, dim) / sigmaN / sigmaN);
		sum += weight;

		for (int j = 0; j < dim; j++)
			a[j] += points[index*dim + j]*weight;

		d = 0;
		for (int j = 0; j < dim; j++)
			d += normals[index*dim + j]*(point[j] - points[index*dim + j]);

		for (int j = 0; j < dim; j++)
			b[j] += d*points[index*dim + j]*weight;

		for (int j = 0; j < dim; j++)
			n[j] += normals[index*dim + j] * weight;

		for (int j = 0; j < dim; j++)
			f += d*weight;
	}

	f /= sum; 
	for (int j = 0; j < dim; j++)
	{
		a[j] /= sum;
		b[j] /= sum;
		n[j] /= sum;
	}

	double c = -2/sigmaP/sigmaP;
	for (int j = 0; j < dim; j++)
		normalPrev[j] = n[j] + c*f*a[j] - c*b;

	delete[] a;
	delete[] b;
	delete[] n;

	return f;
}

double computeDistance(double* point, double* normal, double* points, double* normals, int* neighborIndices, double sigmaP, double sigmaN, int* count, int numNeighbors, int dim)
{
	double th = 0.001;
	int maxCount = 100;
	int count = 0;
	double fCurrent, fPrev;
	double* normalPrev = new double[dim];

	fCurrent = computeGradient(point, normal, points, normals, neighborIndices, sigmaP, -1, numNeighbors, dim);
	fPrev = fCurrent + 2*th;
	while (fabs(fPrev - fCurrent) > th && count < maxCount)
	{
		fPrev = fCurrent;
		copyVector(normalPrev, normal, dim);

		fCurrent = computeGradient(point, normal, points, normals, neighborIndices, sigmaP, sigmaN);
	}
	delete[] normalPrev;
	return fCurrent;
}

void project(double* point, double* normal, double* points, double* normals, double sigmaP, double sigmaN, int* neighborIndices, int numNeighbors, int dim)
{
	double th = 0.001;
	int maxCount = 100;
	int count = 0;
	int numIterations = 0;
	double distance = 2*th;
	double count = 0;
	double currentCount;


	while (fabs(distance) > th && count < maxCount)
	{
		distance = computeDistance(point, normal, points, normals, neighborIndices, sigmaP, sigmaN, &currentCount, numNeighbors, dim);
		
		for (int i = 0; i < dim; i++)
			point[i] = point[i] - distance*normal[i];

		count = count + currentCount;
		numIterations++;

	}

	computeDistance(point, normal, points, normals, neighborIndices, sigmaP, sigmaN, &distance, &currentCount, numNeighbors, dim);
}
*/

double computeGradient(double* point, double* normalPrev, double* neighborPoints, double* neighborNormals, double sigmaP, double sigmaN, int numNeighbors, int dim)
{
	double* a = new double[dim];
	double* b = new double[dim];
	double* n = new double[dim];
	double* neighborPoint = new double[dim];
	double* neighborNormal = new double[dim];
	double weight;
	double sum;
	double d;
	double f = 0;

	fillZeros(a, dim);
	fillZeros(b, dim);
	fillZeros(n, dim);

	sum = 0;
	for (int i = 0; i < numNeighbors; i ++)
	{
		for (int j = 0; j < dim; j++)
			neighborPoint[j] = neighborPoints[i*dim + j];

		for (int j = 0; j < dim; j++)
			neighborNormal[j] = neighborNormals[i*dim + j];

		if (sigmaN > 0)
			weight = exp(-sqDistVect(point, neighborPoint, dim) / sigmaP / sigmaP - sqDistVect(normalPrev, neighborNormal, dim) / sigmaN / sigmaN);
		else
			weight = exp(-sqDistVect(point, neighborPoint, dim) / sigmaP / sigmaP);

		sum += weight;

		for (int j = 0; j < dim; j++)
			a[j] += neighborPoint[j]*weight;

		d = 0;
		for (int j = 0; j < dim; j++)
			d += neighborNormal[j]*(point[j] - neighborPoint[j]);

		for (int j = 0; j < dim; j++)
			b[j] += d*neighborPoint[j]*weight;

		for (int j = 0; j < dim; j++)
			n[j] += neighborNormal[j] * weight;

			f += d*weight;
	}

	if (sum > 0)
	{
		f /= sum; 
		for (int j = 0; j < dim; j++)
		{
			a[j] /= sum;
			b[j] /= sum;
			n[j] /= sum;
		}
	}
	else
	{
		printf("WARNING: Sum close to zero.");
	}

	double c = -2/sigmaP/sigmaP;
	for (int j = 0; j < dim; j++)
		normalPrev[j] = n[j] + c*f*a[j] - c*b[j];

	delete[] a;
	delete[] b;
	delete[] n;
	delete[] neighborPoint;
	delete[] neighborNormal;
	
	return f;
}

double computeDistance(double* point, double* normal, double* neighborPoints, double* neighborNormals, double sigmaP, double sigmaN, int* count, int numNeighbors, int dim, bool sharpFeatures)
{
	double th = 0.001;
	int maxCount = 10;
	*count = 0;
	double fCurrent, fPrev;
	double* normalPrev = new double[dim];

	fCurrent = computeGradient(point, normal, neighborPoints, neighborNormals, sigmaP, -1, numNeighbors, dim);

	if (sharpFeatures)
	{
		fPrev = fCurrent + 2*th;
		while (fabs(fPrev - fCurrent) > th && *count < maxCount)
		{
			fPrev = fCurrent;
			copyVector(normalPrev, normal, dim);

			fCurrent = computeGradient(point, normal, neighborPoints, neighborNormals, sigmaP, sigmaN, numNeighbors, dim);
			*count++;
		}
	}

	delete[] normalPrev;
	
	return fCurrent;
}

void project(double* point, double* normal, double sigmaP, double sigmaN, double* neighborPoints, double* neighborNormals, int numNeighbors, int dim, bool sharpFeatures)
{
	double th = 0.001;
	int maxCount = 100;
	int count = 0;
	int numIterations = 0;
	double distance = 2*th;
	int currentCount;


	while (fabs(distance) > th && count < maxCount)
	{
		distance = computeDistance(point, normal, neighborPoints, neighborNormals, sigmaP, sigmaN, &currentCount, numNeighbors, dim, sharpFeatures);
		
		for (int i = 0; i < dim; i++)
			point[i] = point[i] - distance*normal[i];

		//count = count + currentCount;
		count = count + 1;
		numIterations++;

	}

	distance = computeDistance(point, normal, neighborPoints, neighborNormals, sigmaP, sigmaN, &currentCount, numNeighbors, dim, sharpFeatures);
}

#endif