
#define MAX_NUM_NEIGHBORS_RELAXATION 1000

#include "fileIO.h"
#include "relaxation.h"
#include "subsample.h"
#include <string.h>

int main(int argc, char *argv[])
{
	char* inFileName = argv[1];
	char* outFileName = argv[2];
	double sigmaP = atof(argv[3]);
	double sigmaN = atof(argv[4]);
	double th = 0.5;//atof(argv[5]);
	int maxIteration = 10;//(int)atof(argv[6]);
	bool sharpFeatures = 1;//(bool)atof(argv[7]);
	int dim = 3;//(int)atof(argv[8]);
	bool onlySubsample = 0;//(bool)atof(argv[8]);



	//Convert
	//int numPoints;
	//double* points = new double[3*187136];
	//double* normals = new double[3*187136];
	//numPoints = readObj(inFileName, points, normals);
	//writeApts(outFileName, points, normals, numPoints);
	//delete[] points;
	//delete[] normals;
	//exit(0);
	
	//convert_noff_apts(inFileName, outFileName);
	//exit(0);

	
	//scaleApts(inFileName);
	//exit(0);
	

	//Random Shuffling
	//randomlyShufflePointsApts(inFileName, inFileName);
	//exit(0);
	

	//Subsample
	//-------------------------------------------------------------------------------------------
	int numSampledPoints[1];
	double* pointsNormals = subsample(inFileName, sigmaP, sigmaN, th, numSampledPoints);
	printf("Subsampling Done");
	//char* outFileNameSubsampling = "";
	//strcat(outFileNameSubsampling, outFileName);
	//strcat(outFileNameSubsampling, "_simplified.apts");
	writeNoff(outFileName, pointsNormals, numSampledPoints[0], dim);
	//writeXYZ("test.txt", pointsNormals, numSampledPoints[0], 2*dim);
	delete[] pointsNormals;
	//-------------------------------------------------------------------------------------------

	//-------------------------------------------------------------------------------------------
	if (onlySubsample)
		exit(0);
	//-------------------------------------------------------------------------------------------

	//Resample
	//-------------------------------------------------------------------------------------------
	int numPoints;
	double* pointsAndNormals[2];
	numPoints = readNoff(outFileName, pointsAndNormals);
	double* points = pointsAndNormals[0];
	double* normals = pointsAndNormals[1];
	relaxPoints(points, normals, numPoints, dim, sigmaP, sigmaN, MAX_NUM_NEIGHBORS_RELAXATION, maxIteration, sharpFeatures);
	printf("Resampling Done.");
	//writeApts("test.apts", points, normals, numPoints);
	writeNoff(outFileName, points, normals, numPoints, dim);
	delete[] points;
	delete[] normals;
	//-------------------------------------------------------------------------------------------

}
