#ifndef TAKE_INVERSE_ITERATIVE_H
#define TAKE_INVERSE_ITERATIVE_H

#include <math.h>
#include <malloc.h>


void matrixVectorProduct(double* M, double* v, double* r, unsigned int m, unsigned int n)
{
	for (unsigned int i = 0; i < m; i++)
	{
		r[i] = 0;
		for (unsigned int j = 0; j < n; j++)
			r[i] += M[i*n + j]*v[j];
	}
}

void dotProduct(double* v1, double* v2, double* r, unsigned int n)
{
	for (unsigned int i = 0; i < n; i++)
		r[i] = v1[i] * v2[i];
}

double sqDistVM(double* v1, double* M, unsigned int index, unsigned int d)
{
	double distance = 0;
	for (unsigned int i = 0; i < d; i++)
		distance += (v1[i] - M[index*d + i])*(v1[i] - M[index*d + i]);
	return distance;
}

double sqDistMM(double* M1, double* M2, unsigned int index1, unsigned int index2, unsigned int d)
{
	double distance = 0;
	for (unsigned int i = 0; i < d; i++)
		distance += (M1[index1*d + i] - M2[index2*d + i])*(M1[index1*d + i] - M2[index2*d + i]);
	return distance;
}

double sqDistVect(double* v1, double* v2, unsigned int n)
{
	double distance = 0;
	for (unsigned int i = 0; i < n; i++)
		distance += (v1[i] - v2[i])*(v1[i] - v2[i]);
	return distance;
}

double takeInverseIterative(double* x, double* sampledPointNormals, int* neighborIndices, int num, int dim, double th)
{
	//Vars
	//double* Kn = (double*)_malloca(num*num*sizeof(double));
	//double* kx = (double*)_malloca(num*sizeof(double));
	//double* kn_np1 = (double*)_malloca(num*sizeof(double));
	//double* e = (double*)_malloca(num*sizeof(double));
	double* Kn = new double[num*num];
	double* kx = new double[num];
	double* kn_np1 = new double[num];
	double* e = new double[num];
    
	double dot, dp, f, error;
	 
	double dpTH = 0.00001;
	unsigned int k = 0;
    int index = 0;
	//double dx_a = 1/(dx*dx);
	//double dx_b = (1 - (1/dx))*(1/dx);

	//Init

	for (int i = 0; i < num*num; i++)
        Kn[i] = 0;
    
	Kn[0] = 1;
    kx[0] = exp(-sqDistVM(x, sampledPointNormals, neighborIndices[0], 2*dim));
	//for (unsigned int m = 0; m < num; m++)
	//	kx[m] = exp(-sqDistVM(x, pointsNormals, m, dim));
    
	double p = Kn[0]*kx[0]*kx[0]; 
    
	//Run
	//while (index < num-1 && dx_a + dx_b*(1-p) > th)
	while (index < num-1 && (1-p) >= th)
    //while (index < num-1)
	{
        
		k++;
        index++;
        
        
		for (unsigned int m = 0; m < k; m++)
			kn_np1[m] = exp(-sqDistMM(sampledPointNormals, sampledPointNormals, neighborIndices[index], neighborIndices[m], 2*dim));

	    
		for (unsigned int m = 0; m < k; m++)
		{
			e[m] = 0;
			for (unsigned int n = 0; n < k; n++)
				e[m] = e[m] + Kn[m*num + n]*kn_np1[n];
		}

		dot = 0;
		for (unsigned int m = 0; m < k; m++)
			dot = dot + kn_np1[m]*e[m];
	    
		if ((1 - dot) < dpTH)
        {
            k--;
			continue;
        }
	    
		dp = 1/(1 - dot);
	    
		for (unsigned int m = 0; m < k; m++)
			for (unsigned int n = 0; n < k; n++)
				Kn[m*num + n] = Kn[m*num + n] + dp*e[m]*e[n];

		for (unsigned int m = 0; m < k; m++)
		{
			Kn[m*num + k] = -dp*e[m];
			Kn[k*num + m] = Kn[m*num + k];
		}
	    
		Kn[k*num + k] = dp;
	    
		f = 0;
		for (unsigned int m = 0; m < k; m++)
			f = f + kx[m]*e[m];
	    
        kx[k] = exp(-sqDistVM(x, sampledPointNormals, neighborIndices[index], 2*dim));
		error = dp*(f-kx[k])*(f-kx[k]);
		p = p + error;
         
	}

	//Clean
	//_freea(Kn);
	//_freea(kx);
	//_freea(kn_np1);
	//_freea(e);
    delete[] Kn;
    delete[] kx;
    delete[] kn_np1;
    delete[] e;
    
	//Return 
	return p;
}

double takeInverseIterative(double* x, double dx, double* pointsNormals, unsigned int num, unsigned int dim, double th)
{
	//Vars
	double* Kn = (double*)_malloca(num*num*sizeof(double));
	double* kx = (double*)_malloca(num*sizeof(double));
	double* kn_np1 = (double*)_malloca(num*sizeof(double));
	double* e = (double*)_malloca(num*sizeof(double));
    unsigned int* pointMask = (unsigned int*)_malloca(num*sizeof(unsigned int));
	double dot, dp, f, error;
	 
	double dpTH = 0.001;
	unsigned int k = 0;
    unsigned int index = 0;
	double dx_a = 1/(dx*dx);
	double dx_b = (1 - (1/dx))*(1/dx);

	//Init
	Kn[0] = 1;
    kx[0] = exp(-sqDistVM(x, pointsNormals, 0, dim));
	//for (unsigned int m = 0; m < num; m++)
	//	kx[m] = exp(-sqDistVM(x, pointsNormals, m, dim));
	double p = Kn[0]*kx[0]*kx[0]; 
    
    for (unsigned int m = 0; m < num; m++)
        pointMask[m] = 1;

	
	//Run
	//while (index < num-1 && dx_a + dx_b*(1-p) > th)
    while (index < num-1 && (1-p) >= th)
	//while (index < num-1)
	{
		k++;
        index++;
	 
        unsigned int mm = 0;
		for (unsigned int m = 0; m < index; m++)
        {
            if (pointMask[m] == 1)
            {
                kn_np1[mm] = exp(-sqDistMM(pointsNormals, pointsNormals, index, m, dim));
                mm++;
            }
        }

	      
		for (unsigned int m = 0; m < k; m++)
		{
			e[m] = 0;
			for (unsigned int n = 0; n < k; n++)
				e[m] = e[m] + Kn[m*num + n]*kn_np1[n];
		}

		dot = 0;
		for (unsigned int m = 0; m < k; m++)
			dot = dot + kn_np1[m]*e[m];
	    
		if (abs(1 - dot) < dpTH)
        {
            pointMask[index] = 0;
            k--;
			continue;
        }
	    
		dp = 1/(1 - dot);
	    
		for (unsigned int m = 0; m < k; m++)
			for (unsigned int n = 0; n < k; n++)
				Kn[m*num + n] = Kn[m*num + n] + dp*e[m]*e[n];

		for (unsigned int m = 0; m < k; m++)
		{
			Kn[m*num + k] = -dp*e[m];
			Kn[k*num + m] = Kn[m*num + k];
		}
	    
		Kn[k*num + k] = dp;
	    
		f = 0;
		for (unsigned int m = 0; m < k; m++)
			f = f + kx[m]*e[m];
	    
        kx[k] = exp(-sqDistVM(x, pointsNormals, index, dim));
		error = dp*(f-kx[k])*(f-kx[k]);
		p = p + error;
	}

    //Clean
	_freea(Kn);
	_freea(kx);
	_freea(kn_np1);
	_freea(e);
    
	//Return 
	return p;
}

double takeInverseIterative(double* x, double dx, double* pointsNormals, unsigned int num, unsigned int dim, double th, double* a, int* aIndices, unsigned int* returnK)
{
	//Vars
	double* Kn = (double*)_malloca(num*num*sizeof(double));
	double* kx = (double*)_malloca(num*sizeof(double));
	double* kn_np1 = (double*)_malloca(num*sizeof(double));
	double* e = (double*)_malloca(num*sizeof(double));
    unsigned int* pointMask = (unsigned int*)_malloca(num*sizeof(unsigned int));
	double dot, dp, f, error;
	 
	double dpTH = 0.00001;
	unsigned int k = 0;
    unsigned int index = 0;
	double dx_a = 1/(dx*dx);
	double dx_b = (1 - (1/dx))*(1/dx);

	//Init
	Kn[0] = 1;
    kx[0] = exp(-sqDistVM(x, pointsNormals, 0, dim));
	//for (unsigned int m = 0; m < num; m++)
	//	kx[m] = exp(-sqDistVM(x, pointsNormals, m, dim));
	double p = Kn[0]*kx[0]*kx[0]; 
    
    for (unsigned int m = 0; m < num; m++)
        pointMask[m] = 1;

	
	//Run
	//while (index < num-1 && dx_a + dx_b*(1-p) > th)
    //while (index < num-1 && (1-p) > th)
	while (index < num-1)
	{
		k++;
        index++;
	 
        unsigned int mm = 0;
		for (unsigned int m = 0; m < index; m++)
        {
            if (pointMask[m] == 1)
            {
                kn_np1[mm] = exp(-sqDistMM(pointsNormals, pointsNormals, index, m, dim));
                mm++;
            }
        }

	      
		for (unsigned int m = 0; m < k; m++)
		{
			e[m] = 0;
			for (unsigned int n = 0; n < k; n++)
				e[m] = e[m] + Kn[m*num + n]*kn_np1[n];
		}

		dot = 0;
		for (unsigned int m = 0; m < k; m++)
			dot = dot + kn_np1[m]*e[m];
	    
		//if (abs(1 - dot) < dpTH)
        //{
        //   pointMask[index] = 0;
        //    k--;
		//	continue;
        //}
	    
		dp = 1/(1 - dot);
	    
		for (unsigned int m = 0; m < k; m++)
			for (unsigned int n = 0; n < k; n++)
				Kn[m*num + n] = Kn[m*num + n] + dp*e[m]*e[n];

		for (unsigned int m = 0; m < k; m++)
		{
			Kn[m*num + k] = -dp*e[m];
			Kn[k*num + m] = Kn[m*num + k];
		}
	    
		Kn[k*num + k] = dp;
	    
		f = 0;
		for (unsigned int m = 0; m < k; m++)
			f = f + kx[m]*e[m];
	    
        kx[k] = exp(-sqDistVM(x, pointsNormals, index, dim));
		error = dp*(f-kx[k])*(f-kx[k]);
		p = p + error;
	}

	//Fill a and k, and aIndices
	for (unsigned int i = 0; i < k+1; i++)
	{
		a[i] = 0;
		for (unsigned int j = 0; j < k+1; j++)
		{
			a[i] += Kn[i*num + j]*kx[j];
		}
	}
    unsigned int m = 0;
    for (unsigned int i = 0;i < num;i++)
    {
        if (pointMask[i] == 1)
        {
            aIndices[m] = i;
            m++;
        }
    }
    for (unsigned int i = m;i < num;i++)
        aIndices[m] = -1;
        
	returnK[0] = k;

    //Clean
	_freea(Kn);
	_freea(kx);
	_freea(kn_np1);
	_freea(e);
    
	//Return 
	return p;
}

double takeInverseIterative(double* x, double dx, double* pointsNormals, unsigned int num, unsigned int dim, double th, double* a, int* aIndices, unsigned int* returnK, double* Kn, double* kx)
{
	//Vars
	//double* kx = (double*)_malloca(num*sizeof(double));
	double* kn_np1 = (double*)_malloca(num*sizeof(double));
	double* e = (double*)_malloca(num*sizeof(double));
    unsigned int* pointMask = (unsigned int*)_malloca(num*sizeof(unsigned int));
	double dot, dp, f, error;
	 
	double dpTH = 0.000001;
	unsigned int k = 0;
    unsigned int index = 0;
	//double dx_a = 1/(dx*dx);
	//double dx_b = (1 - (1/dx))*(1/dx);

	//Init
	Kn[0] = 1;
    kx[0] = exp(-sqDistVM(x, pointsNormals, 0, dim));
	//for (unsigned int m = 0; m < num; m++)
	//	kx[m] = exp(-sqDistVM(x, pointsNormals, m, dim));
	double p = Kn[0]*kx[0]*kx[0]; 
    
    for (unsigned int m = 0; m < num; m++)
        pointMask[m] = 1;

	
	//Run
	//while (index < num-1 && dx_a + dx_b*(1-p) > th)
    //while (index < num-1 && (1-p) > th)
	while (index < num-1)
	{
		k++;
        index++;
	 
        unsigned int mm = 0;
		for (unsigned int m = 0; m < index; m++)
        {
            if (pointMask[m] == 1)
            {
                kn_np1[mm] = exp(-sqDistMM(pointsNormals, pointsNormals, index, m, dim));
                mm++;
            }
        }

	      
		for (unsigned int m = 0; m < k; m++)
		{
			e[m] = 0;
			for (unsigned int n = 0; n < k; n++)
				e[m] = e[m] + Kn[m*num + n]*kn_np1[n];
		}

		dot = 0;
		for (unsigned int m = 0; m < k; m++)
			dot = dot + kn_np1[m]*e[m];
	    
		/*
		if (abs(1 - dot) < dpTH)
        {
            pointMask[index] = 0;
            k--;
			continue;
        }
*/

		dp = 1/(1 - dot);


	    
		for (unsigned int m = 0; m < k; m++)
			for (unsigned int n = 0; n < k; n++)
				Kn[m*num + n] = Kn[m*num + n] + dp*e[m]*e[n];

		for (unsigned int m = 0; m < k; m++)
		{
			Kn[m*num + k] = -dp*e[m];
			Kn[k*num + m] = Kn[m*num + k];
		}
	    
		Kn[k*num + k] = dp;
	    
		f = 0;
		for (unsigned int m = 0; m < k; m++)
			f = f + kx[m]*e[m];
	    
        kx[k] = exp(-sqDistVM(x, pointsNormals, index, dim));
		error = dp*(f-kx[k])*(f-kx[k]);
		p = p + error;
	}

	//Fill a and k, and aIndices
	for (unsigned int i = 0; i < k+1; i++)
	{
		a[i] = 0;
		for (unsigned int j = 0; j < k+1; j++)
		{
			a[i] += Kn[i*num + j]*kx[j];
		}
	}
    unsigned int n = 0;
    for (unsigned int i = 0;i < num;i++)
    {
        if (pointMask[i] == 1)
        {
            aIndices[n] = i;
            n++;
        }
    }
    for (unsigned int i = n;i < num;i++)
        aIndices[i] = -1;
        
	returnK[0] = k;

    //Clean
	//_freea(kx);
	_freea(kn_np1);
	_freea(e);
    
	//Return 
	return p;
}


#endif