#ifndef APTS_IO
#define APTS_IO

#define LINE_LENGTH 10000

#include <stdio.h>

int copyFile(char* inFileName, char* outFileName)
{
  FILE *from, *to;
  char ch;

  /* open source file */
  if((from = fopen(inFileName, "rb"))==NULL) {
    printf("Cannot open source file.\n");
  }

  /* open destination file */
  if((to = fopen(outFileName, "wb"))==NULL) {
    printf("Cannot open destination file.\n");
  }

  /* copy the file */
  while(!feof(from)) {
    ch = fgetc(from);
    if(ferror(from)) {
      printf("Error reading source file.\n");
    }
    if(!feof(from)) fputc(ch, to);
    if(ferror(to)) {
      printf("Error writing destination file.\n");
    }
  }

  if(fclose(from)==EOF) {
    printf("Error closing source file.\n");
  }

  if(fclose(to)==EOF) {
    printf("Error closing destination file.\n");
  }

  return 0;
}

void writeApts(char* fileName, const double* points, const double* normals, int numPoints)
{
	FILE* filePointer = fopen (fileName, "w");

	fprintf(filePointer, "[Expe/PointSet/Ascii/0.2]\n");
    fprintf(filePointer, "property position 3 r32\n");
    fprintf(filePointer, "property radius 1 r32\n");
    fprintf(filePointer, "property normal 3 r32\n");
    fprintf(filePointer, "property color 4 ui8\n");
    fprintf(filePointer, "nofpoints      %d\n", numPoints);
    fprintf(filePointer, "data\n");

	for (int i = 0;i < numPoints; i++)
    {
        fprintf(filePointer, "%f %f %f ; 1 ; %f %f %f ; 1 1 1 1\n", 
			points[i*3], points[i*3 + 1], points[i*3 + 2], normals[i*3], normals[i*3 + 1], normals[i*3 + 2]);
    }

    fclose(filePointer);
}

void writeApts(char* fileName, double* pointsNormals, int numPointsNormals)
{
	FILE* filePointer = fopen (fileName, "w");

	fprintf(filePointer, "[Expe/PointSet/Ascii/0.2]\n");
    fprintf(filePointer, "property position 3 r32\n");
    fprintf(filePointer, "property radius 1 r32\n");
    fprintf(filePointer, "property normal 3 r32\n");
    fprintf(filePointer, "property color 4 ui8\n");
    fprintf(filePointer, "nofpoints      %d\n", numPointsNormals);
    fprintf(filePointer, "data\n");

	for (int i = 0;i < numPointsNormals; i++)
    {
        fprintf(filePointer, "%f %f %f ; 1 ; %f %f %f ; 1 1 1 1\n", 
			pointsNormals[i*6], pointsNormals[i*6 + 1], pointsNormals[i*6 + 2], pointsNormals[i*6 + 3], pointsNormals[i*6 + 4], pointsNormals[i*6 + 5]);
   
	}

    fclose(filePointer);
}

int readApts(char* fileName, double** pointsAndNormals)
{
    FILE* filePointer = fopen (fileName, "r");
    
    char line [LINE_LENGTH];
    int num;
    float p[3];
    float n[3];
	float dummy;
	int i = 0;
    
    for (unsigned int i = 0; i < 6; ++i)
        fgets(line, LINE_LENGTH, filePointer);
    sscanf (line,"%*s %d",&num);
    fgets(line, LINE_LENGTH, filePointer);
	printf("%d\n\n", num);
  
	double* points = new double[num*3];
	double* normals = new double[num*3];

    while (fgets(line, LINE_LENGTH, filePointer))
    {
        sscanf (line,"%f %f %f ; %f ; %f %f %f ; %f %f %f %f",&p[0], &p[1], &p[2], &dummy, &n[0], &n[1], &n[2], &dummy, &dummy, &dummy, &dummy);
		//printf("%f %f %f %f %f %f \n", p[0], p[1], p[2], n[0], n[1], n[2]);
		points[3*i] = p[0];
		points[3*i + 1] = p[1];
		points[3*i + 2] = p[2];

		normals[3*i] = n[0];
		normals[3*i + 1] = n[1];
		normals[3*i + 2] = n[2];
		i++;
    }
    
	pointsAndNormals[0] = points;
	pointsAndNormals[1] = normals;

    fclose(filePointer);
	return num;
}

int readNoff(char* noffFileName, double** pointsAndNormals)
{
	FILE* noffFile = fopen(noffFileName, "r");

    char line [LINE_LENGTH];
    int num;
    float p[3];
    float n[3];
	float dummy;
	int i = 0;

	fgets(line, LINE_LENGTH, noffFile);
    sscanf (line,"%d",&num);

	double* points = new double[num*3];
	double* normals = new double[num*3];

	while (fgets(line, LINE_LENGTH, noffFile))
    {
		sscanf(line, "%f %f %f %f %f %f", &p[0], &p[1], &p[2], &n[0], &n[1], &n[2]);

		points[3*i] = p[0];
		points[3*i + 1] = p[1];
		points[3*i + 2] = p[2];

		normals[3*i] = n[0];
		normals[3*i + 1] = n[1];
		normals[3*i + 2] = n[2];
		i++;
	}

	pointsAndNormals[0] = points;
	pointsAndNormals[1] = normals;

	fclose(noffFile);
	return num;
}

void convert_noff_apts(char* noffFileName, char* aptsFileName)
{
	FILE* noffFile = fopen(noffFileName, "r");
	FILE* aptsFile = fopen(aptsFileName, "w");

    char line [LINE_LENGTH];
    int num;
    float p[3];
    float n[3];
	float dummy;


    //fgets(line, LINE_LENGTH, noffFile);
	fgets(line, LINE_LENGTH, noffFile);
    sscanf (line,"%d %*d %*d",&num);

	fprintf(aptsFile, "[Expe/PointSet/Ascii/0.2]\n");
    fprintf(aptsFile, "property position 3 r32\n");
    fprintf(aptsFile, "property radius 1 r32\n");
    fprintf(aptsFile, "property normal 3 r32\n");
    fprintf(aptsFile, "property color 4 ui8\n");
    fprintf(aptsFile, "nofpoints      %d\n", num);
    fprintf(aptsFile, "data\n");

	for (int i = 0;i < num; i++)
    {
		fgets(line, LINE_LENGTH, noffFile);
		sscanf(line, "%f %f %f %f %f %f", &p[0], &p[1], &p[2], &n[0], &n[1], &n[2]);
		fprintf(aptsFile, "%f %f %f ; 1 ; %f %f %f ; 1 1 1 1\n", p[0], p[1], p[2], n[0], n[1], n[2]);
	}

	fclose(noffFile);
	fclose(aptsFile);
}

void writeXYZ(char* fileName, double* points, int numPointsNormals, int DIMOffset)
{
	FILE* filePointer = fopen (fileName, "w");

	for (int i = 0;i < numPointsNormals; i++)
    {
        fprintf(filePointer, "%f %f %f\n", points[i*DIMOffset], points[i*DIMOffset + 1], points[i*DIMOffset + 2]);
    }

    fclose(filePointer);
}

void writeNoff(char* fileName, double* points, double* normals, int numPointsNormals, int DIMOffset)
{
	FILE* filePointer = fopen (fileName, "w");
	
	fprintf(filePointer, "%d\n", numPointsNormals);
	for (int i = 0;i < numPointsNormals; i++)
    {
        fprintf(filePointer, "%f %f %f %f %f %f\n", points[i*DIMOffset], points[i*DIMOffset + 1], points[i*DIMOffset + 2],
			normals[i*DIMOffset], normals[i*DIMOffset + 1], normals[i*DIMOffset + 2]);
    }

    fclose(filePointer);
}

void writeNoff(char* fileName, double* pointsNormals, int numPointsNormals, int DIMOffset)
{
	FILE* filePointer = fopen (fileName, "w");
	
	fprintf(filePointer, "%d\n", numPointsNormals);
	for (int i = 0;i < numPointsNormals; i++)
    {
        fprintf(filePointer, "%f %f %f %f %f %f\n", pointsNormals[i*DIMOffset*2], pointsNormals[i*DIMOffset*2 + 1], pointsNormals[i*DIMOffset*2 + 2],
			pointsNormals[i*DIMOffset*2 + 3], pointsNormals[i*DIMOffset*2 + 4], pointsNormals[i*DIMOffset*2 + 5]);
    }

    fclose(filePointer);
}

int readObj(char* fileName, double* points, double* normals)
{   
	char line [LINE_LENGTH];
    float p[3];
    float n[3];
    int num = 0;
	int i = 0;
	
	FILE* filePointer = fopen (fileName, "r");
	while (fgets(line, LINE_LENGTH, filePointer))
		num++;
	num = (num / 2);

	fclose(filePointer);

	//points = new double[3*num];
	//normals = new double[3*num];

	filePointer = fopen (fileName, "r");
	while (fgets(line, LINE_LENGTH, filePointer))
	{
		sscanf (line,"%*s %f %f %f",&n[0], &n[1], &n[2]);
		fgets(line, LINE_LENGTH, filePointer);
		sscanf (line,"%*s %f %f %f",&p[0], &p[1], &p[2]);

		//printf("\n%f %f %f ", p[0], p[1], p[2]);

		points[3*i] = p[0];
		points[3*i + 1] = p[1];
		points[3*i + 2] = p[2];

		normals[3*i] = n[0];
		normals[3*i + 1] = n[1];
		normals[3*i + 2] = n[2];

		//printf("\n%f %f %f ", points[3*i], points[3*i+1], points[3*i+2]);
		i++;

	}

	return num;
}

void scaleApts(char* fileName)
{
	FILE* aptsFile = fopen(fileName,"r");
    char line [LINE_LENGTH];
    int num;
    float p[3];
    float n[3];
	float dummy;

	//Get scale
	float bbMax[3];
	float bbMin[3];
    
    for (unsigned int i = 0; i < 7; ++i)
        fgets(line, LINE_LENGTH, aptsFile);

    while (fgets(line, LINE_LENGTH, aptsFile))
    {
        sscanf (line,"%f %f %f ; %f ; %f %f %f ; %f %f %f %f",&p[0], &p[1], &p[2], &dummy, &n[0], &n[1], &n[2], &dummy, &dummy, &dummy, &dummy);
		for (int i = 0; i < 2; i++)
		{
			if (p[i] > bbMax[i])
				bbMax[i] = p[i];
			if (p[i] < bbMin[i])
				bbMin[i] = p[i];
		}
		//printf("%f %f %f %f %f %f \n", p[0], p[1], p[2], n[0], n[1], n[2]);
	}
	fclose(aptsFile);
	
	float bbSize[3];
	for (int i = 0; i < 2; i++)
		bbSize[i] = bbMax[i] - bbMin[i];
	float boundingBoxMaxSize = bbSize[0];
	for (int i = 1; i < 2; i++)
		if (bbSize[i] > boundingBoxMaxSize)
			boundingBoxMaxSize = bbSize[i];

	float scale = (float)(100.0/boundingBoxMaxSize);
	printf("\nScale:%f\n",scale);

	//Apply scale
	aptsFile = fopen(fileName,"r");
	FILE* tempFile = fopen("temp.apts","w");

	for (unsigned int i = 0; i < 7; ++i)
	{
        fgets(line, LINE_LENGTH, aptsFile);
		fprintf(tempFile, "%s", line);
	}

    while (fgets(line, LINE_LENGTH, aptsFile))
    {
        sscanf (line,     "%f %f %f ; %f ; %f %f %f ; %f %f %f %f", &p[0], &p[1], &p[2], &dummy, &n[0], &n[1], &n[2], &dummy, &dummy, &dummy, &dummy);
		fprintf(tempFile, "%f %f %f ; %f ; %f %f %f ; %f %f %f %f",  p[0]*scale,  p[1]*scale,  p[2]*scale, 1, n[0], n[1], n[2], 1, 1, 1, 1);
	}
	fclose(aptsFile);
	fclose(tempFile);

	//Copy
	copyFile("temp.apts", fileName);
}

#endif