/*
 * ChartApp.java
 *
 * Created on November 11, 2004, 11:38 AM
 */

package Gui;

import Parser.*;
import Common.*;
import java.util.*;
import javax.swing.tree.*;

/**
 *
 * @author  pjb48
 */
public class ChartApp extends javax.swing.JFrame {
    
    /** The working chart, lexicon and grammar **/
    
    Lexicon lexicon = new Lexicon();
    Grammar grammar = new Grammar();
    String inputString;
    Chart chart;
    
    /** Variables for creating a word **/
   
    private String orth1;
    private String cat1;
   
    /** Variables for creating a rule **/
   
    String mother1;
   
    /** Packing flag for the ChartParser **/
    
    boolean packing = false;
    
    /** Creates new form ChartApp */
    public ChartApp() {
        initComponents();
        jTextArea1.setText("input your grammar and lexicon using the menu options...\n");
        jTextField1.setCaretPosition(1);
        
    }
    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel3 = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        parseButton = new javax.swing.JButton();
        packingRadioButton = new javax.swing.JRadioButton();
        jTextField1 = new javax.swing.JTextField();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        chartPane2 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        TreePane3 = new javax.swing.JScrollPane();
        jTree1 = new javax.swing.JTree();
        menuBar = new javax.swing.JMenuBar();
        grammarMenu = new javax.swing.JMenu();
        addRuleMenuItem = new javax.swing.JMenuItem();
        showGrammarMenuItem = new javax.swing.JMenuItem();
        loadFileMenuItem2 = new javax.swing.JMenuItem();
        SaveFileMenuItem2 = new javax.swing.JMenuItem();
        lexiconMenu = new javax.swing.JMenu();
        addWordMenuItem = new javax.swing.JMenuItem();
        showMenuItem = new javax.swing.JMenuItem();
        loadFileMenuItem1 = new javax.swing.JMenuItem();
        SaveFileMenuItem1 = new javax.swing.JMenuItem();
        helpMenu = new javax.swing.JMenu();
        exitMenu = new javax.swing.JMenu();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        jPanel3.setLayout(new java.awt.BorderLayout());

        jPanel3.setMinimumSize(new java.awt.Dimension(600, 800));
        parseButton.setText("Parse");
        parseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                parseButtonActionPerformed(evt);
            }
        });

        jPanel1.add(parseButton);

        packingRadioButton.setText("Packing");
        packingRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                packingRadioButtonActionPerformed(evt);
            }
        });

        jPanel1.add(packingRadioButton);

        jPanel3.add(jPanel1, java.awt.BorderLayout.EAST);

        jTextField1.setText(">");
        jTextField1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField1ActionPerformed(evt);
            }
        });
        jTextField1.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                jTextField1KeyPressed(evt);
            }
        });

        jPanel3.add(jTextField1, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanel3, java.awt.BorderLayout.NORTH);

        jTabbedPane1.setPreferredSize(new java.awt.Dimension(500, 400));
        jTextArea1.setEditable(false);
        chartPane2.setViewportView(jTextArea1);

        jTabbedPane1.addTab("Chart", chartPane2);

        jTree1.setDoubleBuffered(true);
        jTree1.setFocusable(false);
        jTree1.setName("Parse Trees");
        TreePane3.setViewportView(jTree1);

        jTabbedPane1.addTab("Tree", TreePane3);

        getContentPane().add(jTabbedPane1, java.awt.BorderLayout.CENTER);

        grammarMenu.setText("Grammar");
        grammarMenu.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                grammarMenuActionPerformed(evt);
            }
        });

        addRuleMenuItem.setText(" Add Rule (F12)");
        addRuleMenuItem.setActionCommand("Add Rule (F12)");
        addRuleMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addRuleMenuItemActionPerformed(evt);
            }
        });

        grammarMenu.add(addRuleMenuItem);

        showGrammarMenuItem.setText("Show Grammar");
        showGrammarMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showGrammarMenuItemActionPerformed(evt);
            }
        });

        grammarMenu.add(showGrammarMenuItem);

        loadFileMenuItem2.setText("Load Grammar");
        loadFileMenuItem2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadFileMenuItem2ActionPerformed(evt);
            }
        });

        grammarMenu.add(loadFileMenuItem2);

        SaveFileMenuItem2.setText("Save Grammar");
        SaveFileMenuItem2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SaveFileMenuItem2ActionPerformed(evt);
            }
        });

        grammarMenu.add(SaveFileMenuItem2);

        menuBar.add(grammarMenu);

        lexiconMenu.setText("Lexicon");
        lexiconMenu.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lexiconMenuActionPerformed(evt);
            }
        });

        addWordMenuItem.setText("Add Word (F8)");
        addWordMenuItem.setDebugGraphicsOptions(javax.swing.DebugGraphics.NONE_OPTION);
        addWordMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addWordMenuItemActionPerformed(evt);
            }
        });

        lexiconMenu.add(addWordMenuItem);

        showMenuItem.setText("Show Lexicon");
        showMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showMenuItemActionPerformed(evt);
            }
        });

        lexiconMenu.add(showMenuItem);

        loadFileMenuItem1.setText("Load Lexicon");
        loadFileMenuItem1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadFileMenuItem1ActionPerformed(evt);
            }
        });

        lexiconMenu.add(loadFileMenuItem1);

        SaveFileMenuItem1.setText("Save Lexicon");
        SaveFileMenuItem1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SaveFileMenuItem1ActionPerformed(evt);
            }
        });

        lexiconMenu.add(SaveFileMenuItem1);

        menuBar.add(lexiconMenu);

        helpMenu.setText("Help");
        helpMenu.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                helpMenuActionPerformed(evt);
            }
        });
        helpMenu.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                helpMenuMouseClicked(evt);
            }
        });

        menuBar.add(helpMenu);

        exitMenu.setText("Exit");
        exitMenu.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitMenuActionPerformed(evt);
            }
        });
        exitMenu.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                exitMenuMouseClicked(evt);
            }
        });

        menuBar.add(exitMenu);

        setJMenuBar(menuBar);

        pack();
    }//GEN-END:initComponents

    private void helpMenuMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_helpMenuMouseClicked
        new HelpDialogue(this, true).show();
    }//GEN-LAST:event_helpMenuMouseClicked

    private void helpMenuActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_helpMenuActionPerformed
        new HelpDialogue(this, true).show();
    }//GEN-LAST:event_helpMenuActionPerformed

    private void SaveFileMenuItem2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SaveFileMenuItem2ActionPerformed
        new FileDialogue(this,true,grammar,false).show();
        jTextField1.setText(">");
        jTextArea1.setText("grammar saved!");
    }//GEN-LAST:event_SaveFileMenuItem2ActionPerformed

    private void loadFileMenuItem2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadFileMenuItem2ActionPerformed
        new FileDialogue(this,true,grammar,true).show();
        jTextField1.setText(">");
        jTextArea1.setText(grammar.toString());
    }//GEN-LAST:event_loadFileMenuItem2ActionPerformed

    private void SaveFileMenuItem1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SaveFileMenuItem1ActionPerformed
        new FileDialogue(this,true,lexicon,false).show();
        jTextField1.setText(">");
        jTextArea1.setText("lexicon saved!");
    }//GEN-LAST:event_SaveFileMenuItem1ActionPerformed

    private void loadFileMenuItem1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadFileMenuItem1ActionPerformed
        new FileDialogue(this,true,lexicon,true).show();
        jTextField1.setText(">");
        jTextArea1.setText(lexicon.toString());
    }//GEN-LAST:event_loadFileMenuItem1ActionPerformed

    private void jTextField1KeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTextField1KeyPressed
        int newChar = evt.getKeyCode();
        if(newChar == 119){
            jTextField1.setText("new word=");
        }
        if(newChar == 123){
            jTextField1.setText("lhs of rule (eg. s)=");
        }
    }//GEN-LAST:event_jTextField1KeyPressed

    
    
    private void showGrammarMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showGrammarMenuItemActionPerformed
        jTextArea1.setText(grammar.toString());
    }//GEN-LAST:event_showGrammarMenuItemActionPerformed

    private void addRuleMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addRuleMenuItemActionPerformed
        jTextField1.setText("lhs of rule (eg. s)=");
    }//GEN-LAST:event_addRuleMenuItemActionPerformed

        
    private void jTextField1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField1ActionPerformed

        String input = jTextField1.getText();
        StringTokenizer tokens = new StringTokenizer(input,"=\r\n\f"); 
        while(tokens.hasMoreTokens()) {
            String currentToken = tokens.nextToken();
            if(currentToken.equals("new word")){
                orth1 = tokens.nextToken();
                jTextField1.setText("syntactic category=");
            }
            else if(currentToken.equals("syntactic category")){
                jTextField1.setText(">");
                cat1 = tokens.nextToken();
                Word word = new Word(orth1, cat1);
                lexicon.add(word);
                jTextArea1.append(orth1 + " (" + cat1 + ") added to lexicon.\n");
            }
            else if(currentToken.equals("lhs of rule (eg. s)")){
                mother1 = tokens.nextToken();
                jTextField1.setText("rhs of rule (eg. np vp)=");
            }
            else if(currentToken.equals("rhs of rule (eg. np vp)")){ 
                jTextField1.setText(">");
                String daughters = tokens.nextToken();
                StringTokenizer daughterBuf = new StringTokenizer(daughters);
                Vector daughterList = new Vector();
                while(daughterBuf.hasMoreTokens()){
                    String toAdd = daughterBuf.nextToken();
                    daughterList.add(toAdd);
                }      
                Rule rule = new Rule(mother1, daughterList);
                grammar.add(rule);
                jTextArea1.append(rule.toString() + " added to grammar\n");
            }
            else if(input.equals(">")){
                jTextField1.setText(">");
            } 
            else{
                jTextField1.setText(">");
                StringBuffer inputBuf = new StringBuffer(input);
                inputBuf.deleteCharAt(0);
                inputString = inputBuf.toString();
                jTextArea1.append(inputString + "\n");
                parse();
            }
        }
    }//GEN-LAST:event_jTextField1ActionPerformed

    private void showMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showMenuItemActionPerformed
        jTextArea1.setText(lexicon.toString());
    }//GEN-LAST:event_showMenuItemActionPerformed

    private void exitMenuMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_exitMenuMouseClicked
        System.exit(0);
    }//GEN-LAST:event_exitMenuMouseClicked

    private void exitMenuActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitMenuActionPerformed
        System.exit(0);
    }//GEN-LAST:event_exitMenuActionPerformed

    private void packingRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_packingRadioButtonActionPerformed
       if(this.packing){
           this.packing = false;
       }
       else{
           this.packing = true;
       }
       chart.packing = this.packing;
    }//GEN-LAST:event_packingRadioButtonActionPerformed

    public void parse(){
        if(inputString!=null && lexicon.size()!=0 && grammar.size()!=0){
            StringTokenizer tokens = new StringTokenizer(inputString);
            int i = 0;
            jTextArea1.setText(i+"");
            while(tokens.hasMoreTokens()){
                i++;
                String nextToken = tokens.nextToken();
                jTextArea1.append(" " + nextToken + " " + i);
            }
            jTextArea1.append("\n");
            chart = new Chart(this.packing);
            Chartparser parser = new Chartparser(chart, inputString, lexicon, grammar);
            
            String success = parser.initChart();
            if(!(success.equals("0"))){
                new ErrorDialogue(this,true,success).show();
                return;
            }
            jTextArea1.append(chart.toString());
            jTextArea1.append("building chart...\n");
            
            parser.buildChart();
            jTextArea1.append(chart.toString());
            
            LinkedList parses = chart.findParses();
            DefaultMutableTreeNode topNode = new DefaultMutableTreeNode(inputString);
            Iterator step1 = parses.iterator();
            while(step1.hasNext()){
                Edge edge = (Edge) step1.next();
                DefaultMutableTreeNode treeNode = chart.buildTree(edge);
                topNode.add(treeNode);
            }
            DefaultTreeModel treeModel = new DefaultTreeModel(topNode);
            jTree1.setModel(treeModel);
            jTree1.updateUI();
        }
        else{
            if(inputString==null){
                new ErrorDialogue(this,true,"no sentence to parse").show();
                jTextField1.setText(">");
                return;
            }
            else if(lexicon.size()==0){
                new ErrorDialogue(this,true,"no entries in lexicon").show();
                jTextField1.setText(">");
                return;
            }
            else{
                new ErrorDialogue(this,true,"no entries in grammar").show();
                jTextField1.setText(">");
                return;
            }
        }
    }
    
    private void parseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_parseButtonActionPerformed
        
        String input = jTextField1.getText();
        String trimmed = input.trim();
        if(!(trimmed.equals(">"))){
            jTextField1.setText(">");
            StringBuffer inputBuf = new StringBuffer(input);
            inputBuf.deleteCharAt(0);
            inputString = inputBuf.toString();
            jTextArea1.append(inputString + "\n");
        }
        parse();
    }//GEN-LAST:event_parseButtonActionPerformed

    private void grammarMenuActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_grammarMenuActionPerformed
 
    }//GEN-LAST:event_grammarMenuActionPerformed

    private void lexiconMenuActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lexiconMenuActionPerformed
    
    }//GEN-LAST:event_lexiconMenuActionPerformed

    private void addWordMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addWordMenuItemActionPerformed
        jTextField1.setText("new word=");
    }//GEN-LAST:event_addWordMenuItemActionPerformed
        
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        
        new ChartApp().show();
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem SaveFileMenuItem1;
    private javax.swing.JMenuItem SaveFileMenuItem2;
    private javax.swing.JScrollPane TreePane3;
    private javax.swing.JMenuItem addRuleMenuItem;
    private javax.swing.JMenuItem addWordMenuItem;
    private javax.swing.JScrollPane chartPane2;
    private javax.swing.JMenu exitMenu;
    private javax.swing.JMenu grammarMenu;
    private javax.swing.JMenu helpMenu;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTree jTree1;
    private javax.swing.JMenu lexiconMenu;
    private javax.swing.JMenuItem loadFileMenuItem1;
    private javax.swing.JMenuItem loadFileMenuItem2;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JRadioButton packingRadioButton;
    private javax.swing.JButton parseButton;
    private javax.swing.JMenuItem showGrammarMenuItem;
    private javax.swing.JMenuItem showMenuItem;
    // End of variables declaration//GEN-END:variables
    
}
