/*
 * Lexicon.java
 *
 * Created on November 3, 2004, 5:20 PM
 */

package Common;

import java.util.*;
import java.io.*;


/**
 * Lexicon class holds mappings between words and syntactic class.
 * Provides functionality for editing the lexicon
 * @author pjb48
 */
public class Lexicon extends TreeSet {
    
    
    /**
     * Print Lexicon
     */    
    public void printLexicon(){
        Iterator step = this.iterator();
        while(step.hasNext()){
            Word currentWord = (Word) step.next();
            currentWord.printWord();
        }
    }
    
    public String toString(){
        StringBuffer output = new StringBuffer();
        Iterator step = this.iterator();
        while(step.hasNext()){
            Word currentWord = (Word) step.next();
            output.append(currentWord.toString());
        }
        return output.toString();
    }
    
    public String lookup(Parser.Chart myChart, String newWord){
        
        boolean foundWord = false;
        
        Iterator step = this.iterator();
        while(step.hasNext()){
            Word currentWord = (Word) step.next();
            if(newWord.equalsIgnoreCase(currentWord.orth)){
                
                foundWord = true;
                
                Edge newEdge = new Edge(myChart.idCounter,
                                        myChart.wordCounter, 
                                        myChart.wordCounter + 1, 
                                        currentWord.tag, null);
                myChart.add(newEdge);
                myChart.idCounter++;
                
            }
        }
        if(!foundWord){
            String returnString = new String("Word " + newWord + " not in lexicon!");
            return returnString;
        }
        myChart.wordCounter++;
        return("0");
    }
    
    public boolean readFile(String fileName){
        File inputFile = new File(fileName);
        try{
        FileReader in = new FileReader(inputFile);
        try{
        BufferedReader inBuf = new BufferedReader(in);
        String line = inBuf.readLine();
        boolean invalidEntry = false;
        while(line!=null){
            StringTokenizer tokens = new StringTokenizer(line);
            if(tokens.countTokens()==2){
                String orth = tokens.nextToken();
                String cat = tokens.nextToken();
                this.add(new Word(orth,cat));
            }
            else{
                System.out.println("Invalid word Entry: "+line);
            }
            line = inBuf.readLine();    
        }
        }
        catch(IOException e1){
            System.out.println(e1.toString());
            return false;
        }
        }
        catch(FileNotFoundException e2){
            System.out.println(e2.toString());
            return false;
            
        }
        return true;
    }
    
    public boolean writeFile(String fileName){
        File outputFile = new File(fileName);
        try{
        FileWriter out = new FileWriter(outputFile);
        BufferedWriter outBuf = new BufferedWriter(out);
        Iterator step1 = this.iterator();
        while(step1.hasNext()){
            Word currentWord = (Word) step1.next();
            outBuf.write(currentWord.orth+" "+currentWord.tag);
            outBuf.newLine();
            outBuf.flush();
        }
        }
        catch(IOException e1){
            System.out.println(e1.toString());
            return false;
        }
        return true;
    }
    
    
}
