/*
 * Grammar.java
 *
 * Created on November 8, 2004, 11:37 AM
 */

package Common;

import java.util.*;
import java.io.*;

/**
 * Stores and edits a grammar
 * @author  pjb48
 */
public class Grammar extends TreeSet{
    
    
    public void printGrammar(){
        Iterator step = this.iterator();
        while(step.hasNext()){
            Rule currentRule = (Rule) step.next();
            currentRule.printRule();
        }
      
    }
    
    public String toString(){
        StringBuffer output = new StringBuffer();
        Iterator step = this.iterator();
        while(step.hasNext()){
            Rule currentRule = (Rule) step.next();
            output.append(currentRule.toString()+"\n");
        }
	return output.toString();
    }
    
    public boolean readFile(String fileName){
        File inputFile = new File(fileName);
        try{
        FileReader in = new FileReader(inputFile);
        try{
        BufferedReader inBuf = new BufferedReader(in);
        String line = inBuf.readLine();
        while(line!=null){
            boolean invalidRule = false;
            StringTokenizer tokens = new StringTokenizer(line);
            if(tokens.countTokens()>2){
                String mother = tokens.nextToken();
                if(tokens.nextToken().equals("->")){
                    Vector daughters = new Vector();
                    while(tokens.hasMoreTokens()){
                        daughters.add(tokens.nextToken());
                    }
                    this.add(new Rule(mother,daughters));
                }
                else{
                    invalidRule = true;
                }
            }
            else{
                invalidRule = true;
            }
            line = inBuf.readLine();    
            if(invalidRule){
                System.out.println("Invalid rule: "+ line);
            }
        }
        }
        catch(IOException e1){
            System.out.println(e1.toString());
            return false;
        }
        }
        catch(FileNotFoundException e2){
            System.out.println(e2.toString());
            return false;
            
        }
        return true;
    }
    
    public boolean writeFile(String fileName){
        File outputFile = new File(fileName);
        try{
        FileWriter out = new FileWriter(outputFile);
        BufferedWriter outBuf = new BufferedWriter(out);
        Iterator step1 = this.iterator();
        while(step1.hasNext()){
            Rule currentRule = (Rule) step1.next();
            outBuf.write(currentRule.mother+" ->");
            Iterator step2 = currentRule.daughterList.iterator();
            while(step2.hasNext()){
                outBuf.write(" " + step2.next());
            }
            outBuf.newLine();
            outBuf.flush();
        }
        }
        catch(IOException e1){
            System.out.println(e1.toString());
            return false;
        }
        return true;
    }
    
    
}
