/*
 * Chart.java
 *
 * Created on November 8, 2004, 2:16 PM
 */

package Parser;

import java.util.*;
import Common.*;
import javax.swing.tree.*;
import javax.swing.*;

/**
 *
 * @author  pjb48
 */
public class Chart extends Vector{
    
    private Edge packedEdge;
    private boolean equalDaughters = false;
    
    public boolean packing;
    
    public int idCounter;
    public int wordCounter;
    
    int edgeLimit = 500;
    
    public Chart(){
        idCounter = 0;
        wordCounter = 0;
        packing = false;
    }
    
    public Chart(boolean packingFlag){
        idCounter = 0;
        wordCounter = 0;
        packing = packingFlag;
    }
    
    public Chart(boolean packingFlag, int limit){
        idCounter = 0;
        wordCounter = 0;
        packing = packingFlag;
        edgeLimit = limit;
    }
    
    public void printChart(){
         Iterator step = this.iterator();
         while(step.hasNext()){
               Edge myEdge = (Edge) step.next();
               myEdge.printEdge();
         }
    }
    
    public String toString(){
        StringBuffer output = new StringBuffer();
        Iterator step = this.iterator();
         while(step.hasNext()){
               Edge myEdge = (Edge) step.next();
               output.append(myEdge.fullToString());
         }
        return output.toString();
    }
    
    public LinkedList findParses(){
        LinkedList parses = new LinkedList();
        for(int i=0; i<this.size();i++){
            Edge edge = (Edge) this.elementAt(i);
            if(edge.motherCat.equalsIgnoreCase("s") && 
                edge.from==0 && 
                edge.to==this.wordCounter){ 
                    parses.add(edge);
            }
        }
        return(parses);
    }
    
    
    boolean spanningEdge(){
        for(int i=0; i<this.size();i++){
            Edge edge = (Edge) this.elementAt(i);
            if(edge.motherCat.equalsIgnoreCase("s") && 
                edge.from==0 && 
                edge.to==this.wordCounter){ 
                    return true;
            }
        }
        return false;
    }
    
    LinkedList findEdges(int from, String motherCat){
        
        LinkedList foundEdges = new LinkedList();
        
        Iterator step = this.iterator();
        while(step.hasNext()){
            Edge currentEdge = (Edge) step.next();
            if(currentEdge.from == from && currentEdge.motherCat.equals(motherCat)){
                foundEdges.add(currentEdge);
            }
        }
        return foundEdges;
    }


    
    private boolean existingEdge(Edge edge){
       
        Iterator step = this.iterator();
        while(step.hasNext()){
            Edge currentEdge = (Edge) step.next();
            if(currentEdge.from == edge.from && 
               currentEdge.to == edge.to &&
               currentEdge.motherCat.equals(edge.motherCat)){
                   LinkedList edgeDaughters = (LinkedList) edge.daughtersList.getFirst();
                   Iterator step2 = currentEdge.daughtersList.iterator();
                 
                   equalDaughters = false;
                   
                   while(step2.hasNext()){
                       LinkedList currentEdgeDaughters = (LinkedList) step2.next();
                       if(haveEqualDaughters(currentEdgeDaughters, edgeDaughters)){
                           equalDaughters = true;
                       }
                   }
                   packedEdge = currentEdge;
                   return true;
            }    
        }
        return false;
    }
      
    
    private boolean haveEqualDaughters(LinkedList a, LinkedList b){
        if(a.size()!=b.size()){
            return false;
        }
        else{
            Iterator stepA = a.iterator();
            Iterator stepB = b.iterator();
            while(stepA.hasNext()){
                Edge edgeA = (Edge) stepA.next(); 
                Edge edgeB = (Edge) stepB.next();
                if(edgeA.id!=edgeB.id){
                    return false;
                }
            }
            return true;
        }
    }
    
    
    public boolean packingAdd(Edge newEdge){
       
        if(existingEdge(newEdge)){
            if(!equalDaughters){
                Iterator step = newEdge.daughtersList.iterator();
                while(step.hasNext()){
                    LinkedList daughters = (LinkedList) step.next();
                    packedEdge.daughtersList.add(daughters);  
                }
                equalDaughters = false;
            }
        }
        else{
            this.add(newEdge);
            return true;
        }
        return false;
    }
    
    
    public boolean normalAdd(Edge newEdge){
        boolean exists = false;
        Iterator step = this.iterator();
        while(step.hasNext()){
            Edge currentEdge = (Edge) step.next();
            if(newEdge.equals(currentEdge)){
            exists = true;  
            }
        }
        if(!exists){
            this.add(newEdge);
            return true;
        }
        return false;
    }
     
    public DefaultMutableTreeNode buildTree(Edge startingEdge){
        
        String label = startingEdge.motherCat;
        LinkedList branches = startingEdge.daughtersList;
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(label);
        if(branches!=null){
            Iterator step = branches.iterator();
            while(step.hasNext()){
                LinkedList edgeList = (LinkedList) step.next();
                DefaultMutableTreeNode newTreeNode = new DefaultMutableTreeNode(edgeList);
                treeNode.add(newTreeNode);
                Iterator step2 = edgeList.iterator();
                while(step2.hasNext()){
                    Edge nextEdge = (Edge) step2.next();
                    newTreeNode.add(buildTree(nextEdge));
                }
            }
        }
        return treeNode;
    }
    
   
}
