/*
 * Word.java
 *
 * Created on November 3, 2004, 4:39 PM
 */

package Common;

/**
 * A class representing a word
 * @author pjb48
 */
public class Word implements Comparable{
    
    String orth;
    String tag;
    
    /**
     * Creates a new instance of Word
     * @param word orthography of word
     * @param syntax syntactic category of word
     */
    public Word(String word, String syntax) {
        orth = word;
        tag = syntax;
    }
    
    
    /**
     * Prints the contents of a Word
     */    
    public void printWord(){
        System.out.println(orth + " " + tag);
    }
    
    public String toString(){
        String output = new String();
        output = orth + " " + tag + "\n";
        return output;
    }
    
    public int compareTo(Object obj) {
        
        Word anotherWord = (Word) obj; 
        int value = this.orth.compareTo(anotherWord.orth);
        if(value!=0){
            return(value);
        }
        else{
            return(this.tag.compareTo(anotherWord.tag));
        }
    }
    
}
