CREATE TABLE session (
_ref text, 
uuid text, 
this_host text, 
this_user text, 
last_active text, 
pool text, 
other_config text
);

CREATE TABLE task (
_ref text, 
uuid text, 
name__label text, 
name__description text, 
allowed_operations text, 
current_operations text, 
created text, 
finished text, 
status text, 
session text, 
resident_on text, 
progress text, 
externalpid text, 
stunnelpid text, 
forwarded text, 
forwarded_to text, 
type text, 
result text, 
error_info text, 
other_config text
);

CREATE TABLE event (
_ref text, 
id text, 
timestamp text, 
class text, 
operation text, 
ref text, 
obj_uuid text
);

CREATE TABLE pool (
_ref text, 
uuid text, 
name_label text, 
name_description text, 
master text, 
default_SR text, 
suspend_image_SR text, 
crash_dump_SR text, 
other_config text
);

CREATE TABLE pool_patch (
_ref text, 
uuid text, 
name__label text, 
name__description text, 
version text, 
filename text, 
size text, 
pool_applied text, 
after_apply_guidance text, 
other_config text
);

CREATE TABLE VM (
_ref text, 
uuid text, 
allowed_operations text, 
current_operations text, 
power_state text, 
name__label text, 
name__description text, 
user_version text, 
is_a_template text, 
suspend_VDI text, 
resident_on text, 
scheduled_to_be_resident_on text, 
affinity text, 
memory__static_max text, 
memory__dynamic_max text, 
memory__dynamic_min text, 
memory__static_min text, 
VCPUs__params text, 
VCPUs__max text, 
VCPUs__at_startup text, 
actions__after_shutdown text, 
actions__after_reboot text, 
actions__after_crash text, 
PV__bootloader text, 
PV__kernel text, 
PV__ramdisk text, 
PV__args text, 
PV__bootloader_args text, 
PV__legacy_args text, 
HVM__boot_policy text, 
HVM__boot_params text, 
HVM__shadow_multiplier text, 
platform text, 
PCI_bus text, 
other_config text, 
domid text, 
domarch text, 
last_boot_CPU_flags text, 
is_control_domain text, 
metrics text, 
guest_metrics text, 
last_booted_record text, 
recommendations text, 
xenstore_data text
);

CREATE TABLE VM_metrics (
_ref text, 
uuid text, 
memory__actual text, 
VCPUs__number text, 
VCPUs__utilisation text, 
VCPUs__CPU text, 
VCPUs__params text, 
VCPUs__flags text, 
state text, 
start_time text, 
install_time text, 
last_updated text
);

CREATE TABLE VM_guest_metrics (
_ref text, 
uuid text, 
os_version text, 
PV_drivers_version text, 
PV_drivers_up_to_date text, 
memory text, 
disks text, 
networks text, 
other text, 
last_updated text
);

CREATE TABLE host (
_ref text, 
uuid text, 
name__label text, 
name__description text, 
allowed_operations text, 
current_operations text, 
API_version__major text, 
API_version__minor text, 
API_version__vendor text, 
API_version__vendor_implementation text, 
enabled text, 
software_version text, 
other_config text, 
capabilities text, 
cpu_configuration text, 
sched_policy text, 
supported_bootloaders text, 
logging text, 
suspend_image_sr text, 
crash_dump_sr text, 
hostname text, 
address text, 
metrics text, 
license_params text, 
boot_free_mem text
);

CREATE TABLE host_crashdump (
_ref text, 
uuid text, 
host text, 
timestamp text, 
size text, 
filename text, 
other_config text
);

CREATE TABLE host_patch (
_ref text, 
uuid text, 
name__label text, 
name__description text, 
version text, 
host text, 
filename text, 
applied text, 
timestamp_applied text, 
size text, 
pool_patch text, 
other_config text
);

CREATE TABLE host_metrics (
_ref text, 
uuid text, 
memory__total text, 
memory__free text, 
live text, 
last_updated text
);

CREATE TABLE host_cpu (
_ref text, 
uuid text, 
host text, 
number text, 
vendor text, 
speed text, 
modelname text, 
family text, 
model text, 
stepping text, 
flags text, 
features text, 
utilisation text
);

CREATE TABLE network (
_ref text, 
uuid text, 
name__label text, 
name__description text, 
allowed_operations text, 
current_operations text, 
other_config text, 
bridge text
);

CREATE TABLE VIF (
_ref text, 
uuid text, 
allowed_operations text, 
current_operations text, 
device text, 
network text, 
VM text, 
MAC text, 
MTU text, 
reserved text, 
other_config text, 
currently_attached text, 
status_code text, 
status_detail text, 
runtime_properties text, 
qos__algorithm_type text, 
qos__algorithm_params text, 
qos__supported_algorithms text, 
metrics text
);

CREATE TABLE VIF_metrics (
_ref text, 
uuid text, 
io__read_kbs text, 
io__write_kbs text, 
last_updated text
);

CREATE TABLE PIF (
_ref text, 
uuid text, 
device text, 
network text, 
host text, 
MAC text, 
MTU text, 
VLAN text, 
device_name text, 
metrics text, 
physical text, 
currently_attached text, 
ip_configuration_mode text, 
IP text, 
netmask text, 
gateway text, 
DNS text, 
bond_slave_of text, 
VLAN_master_of text, 
management text, 
other_config text
);

CREATE TABLE PIF_metrics (
_ref text, 
uuid text, 
io__read_kbs text, 
io__write_kbs text, 
carrier text, 
vendor_id text, 
vendor_name text, 
device_id text, 
device_name text, 
speed text, 
duplex text, 
pci_bus_path text, 
last_updated text
);

CREATE TABLE Bond (
_ref text, 
uuid text, 
master text, 
other_config text
);

CREATE TABLE VLAN (
_ref text, 
uuid text, 
tagged_PIF text, 
untagged_PIF text, 
tag text, 
other_config text
);

CREATE TABLE SM (
_ref text, 
uuid text, 
name__label text, 
name__description text, 
type text, 
vendor text, 
copyright text, 
version text, 
required_api_version text, 
configuration text, 
capabilities text, 
other_config text
);

CREATE TABLE SR (
_ref text, 
uuid text, 
name__label text, 
name__description text, 
allowed_operations text, 
current_operations text, 
virtual_allocation text, 
physical_utilisation text, 
physical_size text, 
type text, 
content_type text, 
shared text, 
other_config text, 
default_vdi_visibility text, 
sm_config text
);

CREATE TABLE VDI (
_ref text, 
uuid text, 
name__label text, 
name__description text, 
allowed_operations text, 
current_operations text, 
SR text, 
virtual_size text, 
physical_utilisation text, 
type text, 
sharable text, 
read_only text, 
other_config text, 
storage_lock text, 
location text, 
managed text, 
missing text, 
parent text, 
xenstore_data text, 
sm_config text
);

CREATE TABLE VBD (
_ref text, 
uuid text, 
allowed_operations text, 
current_operations text, 
VM text, 
VDI text, 
device text, 
userdevice text, 
bootable text, 
mode text, 
type text, 
unpluggable text, 
storage_lock text, 
empty text, 
reserved text, 
other_config text, 
currently_attached text, 
status_code text, 
status_detail text, 
runtime_properties text, 
qos__algorithm_type text, 
qos__algorithm_params text, 
qos__supported_algorithms text, 
metrics text
);

CREATE TABLE VBD_metrics (
_ref text, 
uuid text, 
io__read_kbs text, 
io__write_kbs text, 
last_updated text
);

CREATE TABLE PBD (
_ref text, 
uuid text, 
host text, 
SR text, 
device_config text, 
currently_attached text, 
other_config text
);

CREATE TABLE crashdump (
_ref text, 
uuid text, 
VM text, 
VDI text, 
other_config text
);

CREATE TABLE VTPM (
_ref text, 
uuid text, 
VM text, 
backend text
);

CREATE TABLE console (
_ref text, 
uuid text, 
protocol text, 
location text, 
VM text, 
other_config text, 
port text
);

CREATE TABLE user (
_ref text, 
uuid text, 
short_name text, 
fullname text
);

CREATE TABLE schema_version (major text, minor text);
INSERT INTO schema_version (major, minor) VALUES ('5','35');
